/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.service;

import com.sap.cds.feature.messaging.em.jms.EnterpriseMessagingConnectionProvider;
import com.sap.cds.feature.messaging.em.mt.service.EnterpriseMessagingMtHandler;
import com.sap.cds.feature.messaging.em.mt.service.EnterpriseMessagingMtService;
import com.sap.cds.feature.messaging.em.service.EnterpriseMessagingService;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.messaging.utils.MessagingOutboxUtils;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseMessagingServiceConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(EnterpriseMessagingServiceConfiguration.class);
    public static final String BINDING_EM_LABEL = "enterprise-messaging";
    public static final String EM_SHARED_KIND = "enterprise-messaging-shared";
    public static final String INSTANCE_TYPE = "instancetype";
    public static final String MT_INSTANCE_TYPE_VALUE = "reuse";

    private MessagingService createMessagingService(ServiceBinding binding, EnterpriseMessagingConnectionProvider sharedConnectionProvider, CdsProperties.Messaging.MessagingServiceConfig serviceConfig, CdsRuntime runtime, boolean forceShared) {
        EnterpriseMessagingService service;
        if (!forceShared && Objects.equals(MT_INSTANCE_TYPE_VALUE, binding.getCredentials().get(INSTANCE_TYPE))) {
            logger.info("Enterprise messaging service '{}' is going to be created multitenant-aware", (Object)serviceConfig.getName());
            service = new EnterpriseMessagingMtService(serviceConfig, binding, runtime);
        } else {
            service = new EnterpriseMessagingService(serviceConfig, binding, sharedConnectionProvider, runtime);
        }
        return MessagingOutboxUtils.outboxed((MessagingService)service, (CdsProperties.Messaging.MessagingServiceConfig)serviceConfig, (CdsRuntime)runtime);
    }

    public void services(CdsRuntimeConfigurer configurer) {
        CdsProperties.Messaging config = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getMessaging();
        List<ServiceBinding> bindings = configurer.getCdsRuntime().getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, (String)BINDING_EM_LABEL)).collect(Collectors.toList());
        if (bindings.isEmpty()) {
            logger.info("No service bindings with label '{}' found", (Object)BINDING_EM_LABEL);
        } else {
            boolean isSingleBinding = bindings.size() == 1;
            bindings.forEach(binding -> {
                logger.debug("Starting the initialization of the enterprise-messaging service binding '{}'", binding.getName().get());
                EnterpriseMessagingConnectionProvider sharedConnectionProvider = new EnterpriseMessagingConnectionProvider((ServiceBinding)binding);
                boolean createDefaultService = true;
                List serviceConfigs = config.getServicesByBinding((String)binding.getName().get());
                if (!serviceConfigs.isEmpty()) {
                    createDefaultService = false;
                    serviceConfigs.forEach(serviceConfig -> {
                        if (serviceConfig.isEnabled().booleanValue()) {
                            configurer.service((Service)this.createMessagingService((ServiceBinding)binding, sharedConnectionProvider, (CdsProperties.Messaging.MessagingServiceConfig)serviceConfig, configurer.getCdsRuntime(), Objects.equals(EM_SHARED_KIND, serviceConfig.getKind())));
                        }
                    });
                }
                List serviceConfigsByKind = config.getServicesByKind(BINDING_EM_LABEL);
                serviceConfigsByKind.addAll(config.getServicesByKind(EM_SHARED_KIND));
                if (isSingleBinding && !serviceConfigsByKind.isEmpty()) {
                    createDefaultService = false;
                    serviceConfigsByKind.forEach(serviceConfig -> {
                        if (serviceConfig.isEnabled().booleanValue() && !serviceConfigs.stream().anyMatch(c -> c.getName().equals(serviceConfig.getName()))) {
                            configurer.service((Service)this.createMessagingService((ServiceBinding)binding, sharedConnectionProvider, (CdsProperties.Messaging.MessagingServiceConfig)serviceConfig, configurer.getCdsRuntime(), Objects.equals(EM_SHARED_KIND, serviceConfig.getKind())));
                        }
                    });
                }
                if (createDefaultService) {
                    CdsProperties.Messaging.MessagingServiceConfig defConfig = config.getService((String)binding.getName().get());
                    if (StringUtils.isEmpty((String)defConfig.getBinding()) && StringUtils.isEmpty((String)defConfig.getKind())) {
                        configurer.service((Service)this.createMessagingService((ServiceBinding)binding, sharedConnectionProvider, defConfig, configurer.getCdsRuntime(), false));
                    } else {
                        logger.warn("Could not create service for binding '{}': A configuration with the same name is already defined for another kind or binding.", binding.getName().get());
                    }
                }
                logger.debug("Finished the initialization of the enterprise-messaging service binding '{}'", binding.getName().get());
            });
        }
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        ServiceCatalog catalog = configurer.getCdsRuntime().getServiceCatalog();
        if (catalog.getServices(MessagingService.class).map(OutboxService::unboxed).anyMatch(EnterpriseMessagingMtService.class::isInstance)) {
            configurer.eventHandler((Object)new EnterpriseMessagingMtHandler());
        }
    }
}

