/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.jms;

import com.sap.cds.services.messaging.jms.BrokerConnection;
import com.sap.cds.services.messaging.jms.BrokerConnectionProvider;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.servicesdk.xbem.core.MessagingServiceConnectionSettings;
import com.sap.cloud.servicesdk.xbem.core.MessagingServiceFactory;
import com.sap.cloud.servicesdk.xbem.core.exception.MessagingException;
import com.sap.cloud.servicesdk.xbem.core.impl.MessagingServiceFactoryCreator;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.MessagingServiceJmsConnectionFactory;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.MessagingServiceJmsSettings;
import jakarta.jms.ConnectionFactory;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseMessagingConnectionProvider
extends BrokerConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(EnterpriseMessagingConnectionProvider.class);
    private final ServiceBinding binding;

    public EnterpriseMessagingConnectionProvider(ServiceBinding binding) {
        super((String)binding.getName().get());
        this.binding = binding;
    }

    public BrokerConnection createBrokerConnection(String name, Map<String, String> clientProperties) throws MessagingException {
        MessagingServiceJmsSettings settings = new MessagingServiceJmsSettings();
        int oldMaxReconnectAttempts = this.getIntClientProperty("MaxReconnectAttempts", 10, clientProperties);
        int oldInitialReconnectDelay = this.getIntClientProperty("InitialReconnectDelay", 5000, clientProperties);
        int oldReconnectDelay = this.getIntClientProperty("ReconnectDelay", 5000, clientProperties);
        settings.setFailoverMaxReconnectAttempts(this.getIntClientProperty("FailoverMaxReconnectAttempts", oldMaxReconnectAttempts, clientProperties));
        settings.setFailoverInitialReconnectDelay(this.getIntClientProperty("FailoverInitialReconnectDelay", oldInitialReconnectDelay, clientProperties));
        settings.setFailoverReconnectDelay(this.getIntClientProperty("FailoverReconnectDelay", oldReconnectDelay, clientProperties));
        settings.setAmqpIdleTimeout((long)this.getIntClientProperty("AmqpIdleTimeout", -1, clientProperties));
        MessagingServiceFactory messagingServiceFactory = MessagingServiceFactoryCreator.createFactoryFromCredentials((Map)this.binding.getCredentials());
        BrokerConnection connection = new BrokerConnection(name, (ConnectionFactory)messagingServiceFactory.createConnectionFactory(MessagingServiceJmsConnectionFactory.class, (MessagingServiceConnectionSettings)settings));
        return connection;
    }

    private int getIntClientProperty(String prop, int def, Map<String, String> clientProperties) {
        if (clientProperties == null) {
            return def;
        }
        String val = this.getClientProperty(prop, clientProperties);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                logger.error("invalid client configuration value of '{}' property. The default value '{}' is used", (Object)prop, (Object)def);
            }
        }
        return def;
    }

    private String getClientProperty(String prop, Map<String, String> clientProperties) {
        return clientProperties.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(prop)).map(e -> (String)e.getValue()).findFirst().orElse(null);
    }
}

