/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.mt.service;

import com.sap.cds.feature.messaging.em.mt.SubdomainUtils;
import com.sap.cds.feature.messaging.em.mt.service.EnterpriseMessagingMtService;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.mt.DependenciesEventContext;
import com.sap.cds.services.mt.SubscribeEventContext;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.mt.UpgradeEventContext;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"DeploymentService$Default"})
public class EnterpriseMessagingMtHandler {
    private static final Logger logger = LoggerFactory.getLogger(EnterpriseMessagingMtHandler.class);

    @After
    public void addEnterpriseMessagingDependencies(DependenciesEventContext context) {
        List dependencies = context.getResult();
        HashMap bindings = new HashMap();
        context.getCdsRuntime().getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, (String)"enterprise-messaging") && Objects.equals("reuse", b.getCredentials().get("instancetype"))).forEach(b -> bindings.put((String)b.getName().get(), b.getCredentials().get("xsappname").toString()));
        HashSet disabledServices = new HashSet();
        Map configs = context.getCdsRuntime().getEnvironment().getCdsProperties().getMessaging().getServices();
        configs.values().stream().filter(c -> c.isEnabled() == false).forEach(service -> {
            if (bindings.containsKey(service.getName())) {
                disabledServices.add((String)bindings.get(service.getName()));
            } else if (bindings.containsKey(service.getBinding())) {
                disabledServices.add((String)bindings.get(service.getBinding()));
            } else if (bindings.size() == 1 && "enterprise-messaging".equals(service.getKind())) {
                disabledServices.add((String)bindings.values().stream().findFirst().get());
            }
        });
        configs.values().stream().filter(c -> c.isEnabled()).forEach(service -> {
            if (bindings.containsKey(service.getName())) {
                disabledServices.remove(bindings.get(service.getName()));
            } else if (bindings.containsKey(service.getBinding())) {
                disabledServices.remove(bindings.get(service.getBinding()));
            } else if (bindings.size() == 1 && "enterprise-messaging".equals(service.getKind())) {
                disabledServices.remove(bindings.values().stream().findFirst().get());
            }
        });
        bindings.values().stream().filter(xsappname -> !disabledServices.contains(xsappname)).forEach(xsappname -> {
            logger.debug("Providing the enterprise-messaging service instance dependency '{}'", xsappname);
            dependencies.add(Collections.singletonMap("xsappname", xsappname));
        });
    }

    @On
    public void initializeServices(SubscribeEventContext context) {
        String tenantId = context.getTenant();
        String subdomain = (String)context.getOptions().get("subscribedSubdomain");
        logger.info("Starting the enterprise-messaging tenant onboarding for tenant '{}' and subdomain '{}'", (Object)tenantId, (Object)subdomain);
        boolean success = new SubdomainUtils(context.getCdsRuntime()).requestContextWithSubdomain(tenantId, subdomain, requestContext -> context.getServiceCatalog().getServices(MessagingService.class).map(OutboxService::unboxed).filter(EnterpriseMessagingMtService.class::isInstance).map(EnterpriseMessagingMtService.class::cast).map(service -> service.init(tenantId)).reduce(true, (a, b) -> a != false && b != false));
        if (!success) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EM_SUBSCRIPTION_FAILED, new Object[]{tenantId});
        }
    }

    @On
    private void upgradeServices(UpgradeEventContext context) {
        logger.info("Starting the enterprise-messaging tenant upgrade");
        TenantProviderService tenantService = (TenantProviderService)context.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
        HashMap tenantToSubdomain = new HashMap();
        tenantService.readTenantsInfo(Set.of("tenant", "subdomain")).forEach(info -> tenantToSubdomain.put(info.getTenant(), info.getSubdomain()));
        boolean success = context.getTenants().stream().map(tenant -> {
            if (tenantToSubdomain.containsKey(tenant)) {
                SubdomainUtils utils = new SubdomainUtils(context.getCdsRuntime());
                return utils.requestContextWithSubdomain((String)tenant, (String)tenantToSubdomain.get(tenant), tenantReqContext -> context.getCdsRuntime().getServiceCatalog().getServices(MessagingService.class).map(OutboxService::unboxed).filter(EnterpriseMessagingMtService.class::isInstance).map(EnterpriseMessagingMtService.class::cast).map(s -> s.init((String)tenant)).reduce(true, (a, b) -> a != false && b != false));
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNKNOWN_TENANT, new Object[]{tenant});
        }).reduce(true, (a, b) -> a != false && b != false);
        if (!success) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EM_UPGRADE_FAILED, new Object[]{String.join((CharSequence)",", context.getTenants())});
        }
    }
}

