/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.mt.service;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EnterpriseMessagingTenantStatus {
    public static final String STATUS_ONBOARDING = "ONBOARDING";
    public static final String STATUS_INITIAL = "INITIAL";
    public static final String STATUS_SUCCESS = "SUCCESS";
    public static final String STATUS_WARNING = "WARNING";
    public static final String STATUS_ERROR = "ERROR";
    String tenantId;
    Map<String, QueueStatus> services = new HashMap<String, QueueStatus>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Set<Object> unmanagedQueues = new HashSet<Object>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Set<Object> unmanagedWebhooks = new HashSet<Object>();

    public EnterpriseMessagingTenantStatus(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, QueueStatus> getServices() {
        return this.services;
    }

    public Set<Object> getUnmanagedQueues() {
        return this.unmanagedQueues;
    }

    public Set<Object> getUnmanagedWebhooks() {
        return this.unmanagedWebhooks;
    }

    public static class QueueStatus {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        Object queue;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        List<String> topics = new ArrayList<String>();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        List<Object> webhooks = new ArrayList<Object>();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        List<String> unmanagedTopics = new ArrayList<String>();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        List<String> unsubscribedTopics = new ArrayList<String>();
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        String error;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        String warning;
        String status = "SUCCESS";

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            if (error != null) {
                this.error = error;
                this.status = EnterpriseMessagingTenantStatus.STATUS_ERROR;
            }
        }

        public String getWarning() {
            return this.warning;
        }

        public void setWarning(String warning) {
            if (warning != null) {
                if (!this.status.equals(EnterpriseMessagingTenantStatus.STATUS_ERROR)) {
                    this.status = EnterpriseMessagingTenantStatus.STATUS_WARNING;
                }
                this.warning = warning;
            }
        }

        @JsonIgnore
        public boolean isOnboarding() {
            return Objects.equals(this.status, EnterpriseMessagingTenantStatus.STATUS_ONBOARDING);
        }

        @JsonIgnore
        public void setOnboarding() {
            this.status = EnterpriseMessagingTenantStatus.STATUS_ONBOARDING;
        }

        @JsonIgnore
        public void setInitial() {
            this.status = EnterpriseMessagingTenantStatus.STATUS_INITIAL;
            this.setQueue("unknown");
        }

        public String getStatus() {
            return this.status;
        }

        public List<Object> getWebhooks() {
            return this.webhooks;
        }

        public void setWebhooks(List<Object> webhooks) {
            this.webhooks = webhooks;
        }

        public Object getQueue() {
            return this.queue;
        }

        public void setQueue(Object queue) {
            this.queue = queue;
        }

        public List<String> getTopics() {
            return this.topics;
        }

        public void setTopics(List<String> topics) {
            this.topics = topics;
        }

        public List<String> getUnmanagedTopics() {
            return this.unmanagedTopics;
        }

        public void setUnmanagedTopics(List<String> unmanagedTopics) {
            this.unmanagedTopics = unmanagedTopics;
        }

        public List<String> getUnsubscribedTopics() {
            return this.unsubscribedTopics;
        }

        public void setUnsubscribedTopics(List<String> unsubscribedTopics) {
            this.unsubscribedTopics = unsubscribedTopics;
        }
    }
}

