/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.service;

import com.sap.cds.feature.messaging.em.client.EnterpriseMessagingManagementClient;
import com.sap.cds.feature.messaging.em.jms.EnterpriseMessagingConnectionProvider;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.messaging.jms.BrokerConnection;
import com.sap.cds.services.messaging.service.AbstractMessagingService;
import com.sap.cds.services.messaging.service.MessageQueue;
import com.sap.cds.services.messaging.service.MessageTopic;
import com.sap.cds.services.messaging.service.MessagingBrokerQueueListener;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.apache.qpid.jms.message.JmsBytesMessage;
import org.apache.qpid.jms.message.JmsTextMessage;
import org.apache.qpid.jms.message.facade.JmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsBytesMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsTextMessageFacade;

public class EnterpriseMessagingService
extends AbstractMessagingService {
    private static final Pattern NAMESPACE_WILDCARD_PATTERN = Pattern.compile("([^/]*/[^/]*/[^/]*/)");
    private static final String NAMESPACE_WILDCARD = "+/+/+/";
    private static final String NAMESPACE_PLACEHOLDER = "$namespace";
    protected final EnterpriseMessagingManagementClient managementClient;
    private final EnterpriseMessagingConnectionProvider connectionProvider;
    private final String queueNamespace;
    private volatile BrokerConnection connection;

    public EnterpriseMessagingService(CdsProperties.Messaging.MessagingServiceConfig serviceConfig, ServiceBinding binding, EnterpriseMessagingConnectionProvider connectionProvider, CdsRuntime runtime) {
        super(EnterpriseMessagingService.resolveConfig(serviceConfig, EnterpriseMessagingService.getNamespaceFromBinding(binding)), runtime);
        this.connectionProvider = connectionProvider;
        this.managementClient = new EnterpriseMessagingManagementClient(binding);
        this.queueNamespace = EnterpriseMessagingService.normalizeNamespace(EnterpriseMessagingService.getNamespaceFromBinding(binding));
    }

    private static String getNamespaceFromBinding(ServiceBinding binding) {
        String namespace = (String)binding.getCredentials().get("namespace");
        if (namespace != null && (namespace = namespace.trim()).isEmpty()) {
            namespace = null;
        }
        return namespace;
    }

    private static CdsProperties.Messaging.MessagingServiceConfig resolveConfig(CdsProperties.Messaging.MessagingServiceConfig serviceConfig, String namespace) {
        if ("cloudevents".equals(serviceConfig.getFormat())) {
            if (serviceConfig.getSubscribePrefix() == null) {
                serviceConfig.setSubscribePrefix("+/+/+/ce/");
            }
            if (serviceConfig.getPublishPrefix() == null) {
                serviceConfig.setPublishPrefix("$namespace/ce/");
            }
        }
        String normalizedNamespace = EnterpriseMessagingService.normalizeNamespace(namespace);
        if (serviceConfig.getSubscribePrefix() != null) {
            serviceConfig.setSubscribePrefix(serviceConfig.getSubscribePrefix().replace(NAMESPACE_PLACEHOLDER, normalizedNamespace));
        }
        if (serviceConfig.getPublishPrefix() != null) {
            serviceConfig.setPublishPrefix(serviceConfig.getPublishPrefix().replace(NAMESPACE_PLACEHOLDER, normalizedNamespace));
        }
        serviceConfig.getQueue().getConfig().entrySet().forEach(e -> {
            String value;
            Object patt3915$temp = e.getValue();
            if (patt3915$temp instanceof String && (value = (String)patt3915$temp).indexOf(NAMESPACE_PLACEHOLDER) != -1) {
                e.setValue(value.replace(NAMESPACE_PLACEHOLDER, normalizedNamespace));
            }
        });
        return serviceConfig;
    }

    private static String normalizeNamespace(String namespace) {
        return namespace == null ? "" : StringUtils.trim((String)namespace.trim(), (char)'/');
    }

    public void init() {
        this.connectionProvider.asyncConnectionInitialization(this.serviceConfig, connection -> {
            this.connection = connection;
            super.init();
        });
    }

    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    protected void removeQueue(String name) throws IOException {
        this.managementClient.removeQueue(name);
    }

    protected void createQueue(String name, Map<String, Object> properties) throws IOException {
        String dmQueue;
        if (properties.containsKey("deadMsgQueue") && this.managementClient.getQueue(dmQueue = (String)properties.get("deadMsgQueue")) == null) {
            this.managementClient.createQueue(dmQueue, Collections.emptyMap());
        }
        this.managementClient.createQueue(name, properties);
    }

    protected void createQueueSubscription(String queue, String topic) throws IOException {
        this.managementClient.createQueueSubscription(queue, topic);
    }

    protected void registerQueueListener(String queue, MessagingBrokerQueueListener listener) throws IOException {
        this.connection.registerQueueListener("queue:" + queue, listener, m -> this.getMessageTopic(m));
    }

    protected void emitTopicMessage(String topic, TopicMessageEventContext messageEventContext) {
        this.connection.emitTopicMessage("topic:" + topic, messageEventContext);
    }

    protected String toFullyQualifiedQueueName(MessageQueue queue) {
        return queue.isFullyQualified() ? queue.getName().replace(NAMESPACE_PLACEHOLDER, this.queueNamespace) : this.queueNamespace + "/" + queue.getName();
    }

    protected String toFullyQualifiedTopicName(String event, boolean inbound) {
        return super.toFullyQualifiedTopicName(this.isCloudEventsFormat() ? event.replace('.', '/') : event, inbound);
    }

    private String getMessageTopic(Message message) {
        JmsBytesMessage bytesMessage;
        JmsMessageFacade jmsMessageFacade;
        if (message instanceof JmsTextMessage) {
            JmsTextMessage textMessage = (JmsTextMessage)message;
            JmsMessageFacade jmsMessageFacade2 = textMessage.getFacade();
            if (jmsMessageFacade2 instanceof AmqpJmsTextMessageFacade) {
                AmqpJmsTextMessageFacade textMessageFacade = (AmqpJmsTextMessageFacade)jmsMessageFacade2;
                return textMessageFacade.getType();
            }
        } else if (message instanceof JmsBytesMessage && (jmsMessageFacade = (bytesMessage = (JmsBytesMessage)message).getFacade()) instanceof AmqpJmsBytesMessageFacade) {
            AmqpJmsBytesMessageFacade bytesMessageFacade = (AmqpJmsBytesMessageFacade)jmsMessageFacade;
            return bytesMessageFacade.getType();
        }
        return null;
    }

    protected BiPredicate<MessageTopic, String> getTopicMatcher() {
        return (internalTopic, brokerTopic) -> {
            String internalTopicTail;
            String brokerTopicTail;
            if (super.getTopicMatcher().test(internalTopic, brokerTopic)) {
                return true;
            }
            return internalTopic.getBrokerName().startsWith(NAMESPACE_WILDCARD) && (brokerTopicTail = NAMESPACE_WILDCARD_PATTERN.matcher((CharSequence)brokerTopic).replaceFirst("")).equals(internalTopicTail = internalTopic.getBrokerName().substring(NAMESPACE_WILDCARD.length()));
        };
    }
}

