/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.eventhub.adapter;

import com.sap.cds.feature.messaging.eventhub.service.EventHubMessagingService;
import com.sap.cds.feature.messaging.eventhub.utils.EventHubBindingUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.messaging.service.MessagingBrokerQueueListener;
import com.sap.cds.services.messaging.utils.CloudEventUtils;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubWebhookAdapter
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(EventHubWebhookAdapter.class);
    private static final String UNEXPECTED_ERROR_OCCURRED_MESSAGE = "An unexpected error occurred during servlet processing";
    private final CdsRuntime runtime;
    private final List<EventHubMessagingService> messagingServices;
    private final String clientId;
    private final boolean isMultitenant;

    public EventHubWebhookAdapter(CdsRuntime runtime) {
        this.runtime = runtime;
        this.messagingServices = runtime.getServiceCatalog().getServices(MessagingService.class).map(OutboxService::unboxed).filter(EventHubMessagingService.class::isInstance).map(EventHubMessagingService.class::cast).toList();
        ServiceBinding binding = EventHubBindingUtils.getServiceBinding(runtime).get();
        this.clientId = EventHubBindingUtils.getClientId(binding);
        this.isMultitenant = EventHubBindingUtils.isBindingMultitenant(binding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.checkAuthorization(req);
            Message message = new Message(req, this.isMultitenant);
            for (EventHubMessagingService srv : this.messagingServices) {
                if (!srv.isRegisteredBrokerTopic(message.getBrokerTopic())) continue;
                try {
                    srv.getQueueListener().receivedMessage((MessagingBrokerQueueListener.MessageAccess)message);
                    resp.setStatus(202);
                }
                catch (ServiceException exp) {
                    if (!message.isAcknowledged()) throw exp;
                    logger.debug("Suppressed exception, as message should be acknowledged", (Throwable)exp);
                    resp.setStatus(202);
                    continue;
                    return;
                }
            }
        }
        catch (ServiceException e) {
            int httpStatus = e.getErrorStatus().getHttpStatus();
            if (httpStatus >= 500 && httpStatus < 600) {
                logger.error(UNEXPECTED_ERROR_OCCURRED_MESSAGE, (Throwable)e);
            } else {
                logger.debug(UNEXPECTED_ERROR_OCCURRED_MESSAGE, (Throwable)e);
            }
            this.writeErrorResponse(req, resp, httpStatus, e.getMessage());
            return;
        }
        catch (Exception e) {
            logger.error(UNEXPECTED_ERROR_OCCURRED_MESSAGE, (Throwable)e);
            this.writeErrorResponse(req, resp, 500, new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getMessage());
        }
    }

    private void checkAuthorization(HttpServletRequest req) {
        UserInfo userInfo = this.runtime.getProvidedUserInfo();
        String azp = (String)userInfo.getAdditionalAttributes().get("azp");
        if (!userInfo.isSystemUser() || azp == null || !azp.equals(this.clientId)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
        }
    }

    private void writeErrorResponse(HttpServletRequest req, HttpServletResponse resp, int httpStatus, String message) throws IOException {
        String responseContent = "{\"error\":{\"code\":\"" + httpStatus + "\",\"message\":\"" + message + "\"}}";
        resp.setStatus(httpStatus);
        resp.setContentType("application/json");
        resp.getWriter().println(responseContent);
    }

    private static class Message
    implements MessagingBrokerQueueListener.MessageAccess {
        private final String id;
        private final String topic;
        private final Map<String, Object> dataMap;
        private final Map<String, Object> headersMap;
        private final String tenant;
        private volatile boolean acknowledged;

        public Message(HttpServletRequest req, boolean isMultiTenant) {
            this.id = req.getHeader("ce-id");
            this.topic = req.getHeader("ce-type");
            this.tenant = isMultiTenant ? req.getHeader("ce-sapconsumertenant") : null;
            this.headersMap = new HashMap<String, Object>();
            req.getHeaderNames().asIterator().forEachRemaining(h -> {
                if (h.startsWith("ce-")) {
                    this.headersMap.put(h.substring(3), req.getHeader(h));
                }
            });
            logger.debug("Received Event Hub webhook request with type '{}' with ID '{}'", (Object)this.topic, (Object)this.id);
            try {
                String message = new String(req.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                Map map = CloudEventUtils.toMap((String)message);
                this.dataMap = map == null ? new HashMap<String, String>(Map.of("message", message)) : map;
            }
            catch (IOException e) {
                throw new ServiceException("Failed to read body of webhook request with type '{}' with ID '{}'", new Object[]{this.topic, this.id, e});
            }
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            throw new IllegalStateException();
        }

        public Map<String, Object> getDataMap() {
            return this.dataMap;
        }

        public Map<String, Object> getHeadersMap() {
            return this.headersMap;
        }

        public String getBrokerTopic() {
            return this.topic;
        }

        public void acknowledge() {
            this.acknowledged = true;
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }
    }
}

