/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.eventhub.client;

import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClient;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.messaging.utils.CloudEventUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import java.io.IOException;
import java.util.Map;

public class EventHubClient
extends JsonRestClient {
    private static final Map<String, String> HEADER_MAPPINGS = Map.of("id", "ce-id", "specversion", "ce-specversion", "datacontenttype", "Content-Type", "time", "ce-time", "type", "ce-type", "source", "ce-source");

    public EventHubClient(ServiceBinding binding, CdsProperties.ConnectionPool connectionPool) {
        super(ServiceBindingDestinationOptions.forService((ServiceBinding)binding).onBehalfOf(OnBehalfOf.TECHNICAL_USER_PROVIDER).build(), connectionPool);
    }

    public void sendMessage(Map<String, Object> message, Map<String, Object> headers) throws IOException {
        this.postRequest("/", CloudEventUtils.toJson(message), this.convertCloudEventHeaders(headers));
    }

    private Map<String, Object> convertCloudEventHeaders(Map<String, Object> headers) {
        HEADER_MAPPINGS.forEach((ceHeader, ebHeader) -> {
            if (headers.containsKey(ceHeader)) {
                headers.put((String)ebHeader, headers.remove(ceHeader));
            }
        });
        return headers;
    }
}

