/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.eventhub.ord;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.feature.messaging.eventhub.service.EventHubMessagingService;
import com.sap.cds.feature.messaging.eventhub.utils.EventHubBindingUtils;
import com.sap.cds.feature.ord.processor.CdsOrdNodeProcessor;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedEventsProcessor
implements CdsOrdNodeProcessor {
    private static final String INTEGRATION_DEPENDENCIES_KEY = "integrationDependencies";
    private static final Logger logger = LoggerFactory.getLogger(PublishedEventsProcessor.class);
    private CdsRuntime runtime;
    private boolean processedNode = false;
    private String packageOrdId;
    private String packageVersion;
    private boolean hasEventHubBinding = false;
    private String namespace;

    public Predicate<String> predicate() {
        return nodeName -> (INTEGRATION_DEPENDENCIES_KEY.equalsIgnoreCase((String)nodeName) || "packages".equalsIgnoreCase((String)nodeName)) && this.hasEventHubBinding;
    }

    public boolean canGenerate() {
        return !this.processedNode && this.hasEventHubBinding;
    }

    public String getGeneratedNodeName() {
        return INTEGRATION_DEPENDENCIES_KEY;
    }

    public <T extends TreeNode> Optional<T> process(@Nullable String nodeName, @Nullable T node) {
        ArrayNode resultNode;
        ArrayNode integrationDependenciesArray;
        if ("packages".equalsIgnoreCase(nodeName)) {
            this.packageOrdId = this.retrievePackageOrdId(node);
            this.packageVersion = this.retrievePackageVersion(node);
            return Optional.ofNullable(node);
        }
        List<String> consumedEvents = this.getConsumedEvents();
        if (node == null) {
            resultNode = integrationDependenciesArray = JsonNodeFactory.instance.arrayNode();
        } else {
            if (consumedEvents.isEmpty()) {
                return Optional.empty();
            }
            resultNode = (JsonNode)node;
            integrationDependenciesArray = (ArrayNode)node;
        }
        this.validateValues(this.packageOrdId, this.packageVersion);
        ObjectNode integrationDependency = JsonNodeFactory.instance.objectNode();
        integrationDependency.put("ordId", this.namespace + ":integrationDependency:RawEvent:v1");
        integrationDependency.put("title", "Customer Integration Needs");
        integrationDependency.put("partOfPackage", this.packageOrdId);
        integrationDependency.put("version", this.packageVersion);
        integrationDependency.put("visibility", "public");
        integrationDependency.put("releaseStatus", "active");
        integrationDependency.put("mandatory", false);
        ArrayNode aspectsArray = JsonNodeFactory.instance.arrayNode();
        ObjectNode aspectObject = JsonNodeFactory.instance.objectNode();
        aspectsArray.add((JsonNode)aspectObject);
        integrationDependency.putIfAbsent("aspects", (JsonNode)aspectsArray);
        aspectObject.put("title", "RawEvent");
        aspectObject.put("mandatory", false);
        ArrayNode eventResourcesArray = JsonNodeFactory.instance.arrayNode();
        ObjectNode eventResourceObject = JsonNodeFactory.instance.objectNode();
        eventResourcesArray.add((JsonNode)eventResourceObject);
        aspectObject.putIfAbsent("eventResources", (JsonNode)eventResourcesArray);
        eventResourceObject.put("ordId", this.namespace + ":eventResource:RawEvent:v1");
        ArrayNode subsetArray = JsonNodeFactory.instance.arrayNode();
        eventResourceObject.putIfAbsent("subset", (JsonNode)subsetArray);
        consumedEvents.forEach(eventType -> {
            ObjectNode subsetObject = JsonNodeFactory.instance.objectNode();
            subsetObject.put("eventType", eventType);
            subsetArray.add((JsonNode)subsetObject);
        });
        integrationDependenciesArray.add((JsonNode)integrationDependency);
        this.processedNode = true;
        return Optional.of(resultNode);
    }

    private void validateValues(String packageOrdId, String packageVersion) {
        if (StringUtils.isEmpty((String)packageOrdId)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PACKAGE_ORDID_NOT_FOUND, new Object[0]);
        }
        if (StringUtils.isEmpty((String)packageVersion)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PACKAGE_VERSION_NOT_FOUND, new Object[0]);
        }
    }

    private String retrieveNamespaceFromBindings(ServiceBinding binding) {
        String ceSource = (String)((List)binding.getCredentials().get("ceSource")).get(0);
        CharSequence[] components = ceSource.split("/");
        logger.info("ceSource found in service binding; ceSource = {} | components = [{}]", (Object)ceSource, (Object)String.join((CharSequence)", ", components));
        if (components.length > 1) {
            return components[components.length - 1];
        }
        logger.error("Namespace not found in service binding; ceSource = {}", (Object)ceSource);
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NAMESPACE_NOT_FOUND, new Object[0]);
    }

    private <T extends TreeNode> String retrievePackageVersion(T node) {
        ArrayNode packagesNode = (ArrayNode)node;
        if (!packagesNode.isEmpty()) {
            return packagesNode.get(0).get("version").asText();
        }
        return null;
    }

    private <T extends TreeNode> String retrievePackageOrdId(T node) {
        ArrayNode packagesNode = (ArrayNode)node;
        if (!packagesNode.isEmpty()) {
            return packagesNode.get(0).get("ordId").asText();
        }
        return null;
    }

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
        Optional<ServiceBinding> binding = EventHubBindingUtils.getServiceBinding(this.runtime);
        if (binding.isPresent()) {
            this.hasEventHubBinding = true;
            this.namespace = this.retrieveNamespaceFromBindings(binding.get());
        }
    }

    @VisibleForTesting
    List<String> getConsumedEvents() {
        List<String> kinds = List.of("event-hub");
        return this.getConsumedEvents(kinds).toList();
    }

    @VisibleForTesting
    Stream<String> getConsumedEvents(List<String> messagingServiceKinds) {
        HashSet<String> kinds = new HashSet<String>(messagingServiceKinds);
        return this.runtime.getEnvironment().getCdsProperties().getMessaging().getServices().values().stream().filter(messagingServiceConfig -> kinds.contains(messagingServiceConfig.getKind())).map(CdsProperties.Messaging.MessagingServiceConfig::getName).map(serviceName -> (MessagingService)this.runtime.getServiceCatalog().getService(MessagingService.class, serviceName)).map(OutboxService::unboxed).map(service -> (EventHubMessagingService)((Object)service)).flatMap(messagingService -> messagingService.getQueueTopicSubscriptions().entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream())).filter(event -> !"*".equals(event) && !"MESSAGING_ERROR".equals(event));
    }

    @VisibleForTesting
    String getPackageOrdId() {
        return this.packageOrdId;
    }

    @VisibleForTesting
    String getPackageVersion() {
        return this.packageVersion;
    }
}

