/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.eventhub.service;

import com.google.common.collect.ImmutableMap;
import com.sap.cds.feature.messaging.eventhub.client.EventHubClient;
import com.sap.cds.feature.messaging.eventhub.utils.EventHubBindingUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.messaging.service.AbstractMessagingService;
import com.sap.cds.services.messaging.service.MessageTopic;
import com.sap.cds.services.messaging.service.MessagingBrokerQueueListener;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubMessagingService
extends AbstractMessagingService {
    private static final Logger logger = LoggerFactory.getLogger(EventHubMessagingService.class);
    public static final String CE_SOURCE = "ceSource";
    private final String ceSource;
    private final boolean isMultitenant;
    private final MessagingBrokerQueueListener queueListener;
    private final EventHubClient eventHubClient;
    private final Map<String, Set<String>> queueTopicSubscriptions = new HashMap<String, Set<String>>();
    private volatile String providerTenant;

    public EventHubMessagingService(ServiceBinding binding, CdsProperties.Messaging.MessagingServiceConfig serviceConfig, CdsRuntime cdsRuntime) {
        super(EventHubMessagingService.ensureMandatoryConfig(serviceConfig), cdsRuntime);
        this.ceSource = binding.getCredentials().containsKey(CE_SOURCE) ? (String)((List)binding.getCredentials().get(CE_SOURCE)).get(0) + "/" : null;
        this.isMultitenant = EventHubBindingUtils.isBindingMultitenant(binding);
        this.queueListener = new MessagingBrokerQueueListener((MessagingService)this, this.toFullyQualifiedQueueName(this.queue), this.queue, this.runtime, serviceConfig.isStructured());
        this.eventHubClient = this.isMultitenant ? new EventHubClient(binding, serviceConfig.getConnection().getConnectionPool()) : null;
    }

    private static CdsProperties.Messaging.MessagingServiceConfig ensureMandatoryConfig(CdsProperties.Messaging.MessagingServiceConfig serviceConfig) {
        serviceConfig.setFormat("cloudevents");
        serviceConfig.setStructured(true);
        return serviceConfig;
    }

    public void init() {
        super.init();
        String queueName = this.toFullyQualifiedQueueName(this.queue);
        for (MessageTopic topic : this.queue.getTopics()) {
            String topicName = topic.getBrokerName();
            this.cacheQueueTopicSubscription(queueName, topicName);
        }
        if (logger.isDebugEnabled()) {
            this.queue.getTopics().forEach(t -> logger.debug("Registered messaging handler for Event Hub event '{}'", (Object)t.getBrokerName()));
        }
    }

    protected void cacheQueueTopicSubscription(String queueName, String topicName) {
        this.queueTopicSubscriptions.computeIfAbsent(queueName, k -> new HashSet()).add(topicName);
    }

    public Map<String, Set<String>> getQueueTopicSubscriptions() {
        return (Map)this.queueTopicSubscriptions.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> Set.copyOf((Collection)e.getValue())));
    }

    public MessagingBrokerQueueListener getQueueListener() {
        return this.queueListener;
    }

    public boolean isRegisteredBrokerTopic(String event) {
        return this.queue.getTopics().stream().anyMatch(t -> t.getBrokerName().equals(event));
    }

    protected void removeQueue(String name) throws IOException {
    }

    protected void createQueue(String name, Map<String, Object> properties) throws IOException {
    }

    protected void createQueueSubscription(String queue, String topic) throws IOException {
    }

    protected void registerQueueListener(String queue, MessagingBrokerQueueListener listener) throws IOException {
    }

    protected void emitTopicMessage(String topic, TopicMessageEventContext context) {
        if (!this.isMultitenant) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_HUB_EMIT_FAILED, new Object[0]);
        }
        String tenant = this.getTenant((EventContext)context);
        if (context.getData() != null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CLOUDEVENTS_MESSAGE, new Object[0]);
        }
        try {
            Map headers = context.getHeadersMap();
            if (this.ceSource != null) {
                headers.put("source", this.ceSource + tenant);
            }
            logger.debug("Sending message for Event Hub '{}' to type '{}'", (Object)this.getName(), headers.get("type"));
            this.eventHubClient.sendMessage(context.getDataMap(), headers);
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_EMITTING_FAILED, new Object[]{topic, e});
        }
    }

    private String getTenant(EventContext context) {
        String tenant = context.getUserInfo().getTenant();
        if (tenant != null) {
            return tenant;
        }
        if (this.providerTenant != null) {
            return this.providerTenant;
        }
        TenantProviderService tenantService = (TenantProviderService)context.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
        if (tenantService != null) {
            this.providerTenant = tenantService.readProviderTenant();
            if (this.providerTenant != null) {
                return this.providerTenant;
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_HUB_TENANT_CONTEXT_MISSING, new Object[0]);
    }
}

