/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.eventhub.service;

import com.sap.cds.feature.messaging.eventhub.service.EventHubMessagingService;
import com.sap.cds.feature.messaging.eventhub.utils.EventHubBindingUtils;
import com.sap.cds.services.Service;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.messaging.utils.MessagingOutboxUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubMessagingServiceConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(EventHubMessagingServiceConfiguration.class);
    public static final String KIND_LABEL = "event-hub";

    public void services(CdsRuntimeConfigurer configurer) {
        CdsProperties.Messaging config = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getMessaging();
        EventHubBindingUtils.getServiceBinding(configurer.getCdsRuntime()).ifPresent(binding -> {
            List serviceConfigsByKind;
            logger.debug("Starting the initialization of the Event Hub service binding '{}'", binding.getName().get());
            boolean createDefaultService = true;
            List serviceConfigs = config.getServicesByBinding((String)binding.getName().get());
            if (!serviceConfigs.isEmpty()) {
                createDefaultService = false;
                serviceConfigs.forEach(serviceConfig -> {
                    if (Boolean.TRUE.equals(serviceConfig.isEnabled())) {
                        this.configureService(configurer, (ServiceBinding)binding, (CdsProperties.Messaging.MessagingServiceConfig)serviceConfig);
                    } else {
                        logger.info("The messaging service '{}' is explicitly disabled via configuration", (Object)serviceConfig.getName());
                    }
                });
            }
            if (!(serviceConfigsByKind = config.getServicesByKind(KIND_LABEL)).isEmpty()) {
                logger.debug("Initialization of the Event Hub based on service binding '{}' and kind '{}'", binding.getName().get(), (Object)KIND_LABEL);
                createDefaultService = false;
                serviceConfigsByKind.forEach(serviceConfig -> {
                    if (Boolean.TRUE.equals(serviceConfig.isEnabled()) && serviceConfigs.stream().noneMatch(c -> c.getName().equals(serviceConfig.getName()))) {
                        this.configureService(configurer, (ServiceBinding)binding, (CdsProperties.Messaging.MessagingServiceConfig)serviceConfig);
                    } else {
                        logger.info("The messaging service '{}' is explicitly disabled via configuration", (Object)serviceConfig.getName());
                    }
                });
            }
            if (createDefaultService) {
                logger.debug("Initialization of the Event Hub service binding '{}' with default messaging configuration", binding.getName().get());
                CdsProperties.Messaging.MessagingServiceConfig defConfig = config.getService((String)binding.getName().get());
                if (StringUtils.isEmpty((String)defConfig.getBinding()) && StringUtils.isEmpty((String)defConfig.getKind())) {
                    this.configureService(configurer, (ServiceBinding)binding, defConfig);
                } else {
                    logger.warn("Could not create service for binding '{}': A configuration with the same name is already defined for another kind or binding.", binding.getName().get());
                }
            }
            logger.debug("Finished the initialization of the Event Hub service binding '{}'", binding.getName().get());
        });
    }

    private void configureService(CdsRuntimeConfigurer configurer, ServiceBinding binding, CdsProperties.Messaging.MessagingServiceConfig serviceConfig) {
        EventHubMessagingService messagingService = new EventHubMessagingService(binding, serviceConfig, configurer.getCdsRuntime());
        configurer.service((Service)MessagingOutboxUtils.outboxed((MessagingService)messagingService, (CdsProperties.Messaging.MessagingServiceConfig)serviceConfig, (CdsRuntime)configurer.getCdsRuntime()));
    }
}

