/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.eventhub.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubBindingUtils {
    private static final Logger logger = LoggerFactory.getLogger(EventHubBindingUtils.class);
    public static final String MT_BINDING_LABEL = "eventmesh-sap2sap-internal";
    public static final String ST_BINDING_LABEL = "event-broker";

    public static Optional<ServiceBinding> getServiceBinding(CdsRuntime runtime) {
        List<ServiceBinding> bindings = runtime.getEnvironment().getServiceBindings().filter(binding -> ServiceBindingUtils.matches((ServiceBinding)binding, (String)MT_BINDING_LABEL) || ServiceBindingUtils.matches((ServiceBinding)binding, (String)ST_BINDING_LABEL)).toList();
        if (bindings.size() == 1) {
            ServiceBinding binding2 = bindings.get(0);
            logger.debug("Found EventBroker binding '{}' with service '{}' and plan '{}'", new Object[]{binding2.getName().get(), binding2.getServiceName().get(), binding2.getServicePlan().get()});
            return Optional.of(binding2);
        }
        if (bindings.size() > 1) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_EVENT_HUB_BINDINGS, new Object[0]);
        }
        return Optional.empty();
    }

    public static String getClientId(ServiceBinding binding) {
        Map credentials = binding.getCredentials();
        Map ias = credentials.getOrDefault("ias", Map.of());
        return (String)ias.get("clientId");
    }

    public static boolean isBindingMultitenant(ServiceBinding binding) {
        return ServiceBindingUtils.matches((ServiceBinding)binding, (String)MT_BINDING_LABEL);
    }
}

