/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.hana;

import java.util.Map;

import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;

/**
 * Converts a HANA {@link ServiceBinding} into a {@link DataSourceDescriptor}
 */
public class HanaDataSourceDescriptor implements DataSourceDescriptor {

	private final String name;
	private final String url;
	private final String username;
	private final String password;

	public HanaDataSourceDescriptor(ServiceBinding binding) {
		this.name = binding.getName().get(); // NOSONAR

		Map<String, Object> credentials = binding.getCredentials();
		this.url = (String) credentials.get("url");
		this.username = (String) credentials.get("user");
		this.password = (String) credentials.get("password");
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getDriverClassName() {
		return "com.sap.db.jdbc.Driver";
	}

	@Override
	public String getUrl() {
		return url;
	}

	@Override
	public String getUsername() {
		return username;
	}

	@Override
	public String getPassword() {
		return password;
	}

}
