/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.hana;

import java.util.List;
import java.util.stream.Collectors;

import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.datasource.DataSourceDescriptorFactory;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;

/**
 * {@link DataSourceDescriptorFactory} for {@link HanaDataSourceDescriptor}
 */
public class HanaDataSourceDescriptorFactory implements DataSourceDescriptorFactory, CdsRuntimeAware {

	private static final String HANA = "hana";

	private CdsRuntime runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public List<DataSourceDescriptor> create() {
		return runtime.getEnvironment().getServiceBindings()
				.filter(b -> ServiceBindingUtils.matches(b, HANA))
				.filter(b -> b.getTags() == null || !b.getTags().contains("managed-hana"))
				.map(b -> new HanaDataSourceDescriptor(b))
				.collect(Collectors.toList());
	}

}
