/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.identity;

import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.ReadProviderTenantEventContext;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.utils.OrderConstants;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;

import java.util.Map;
import java.util.Optional;

@ServiceName(value = TenantProviderService.DEFAULT_NAME, type = TenantProviderService.class)
public class IdentityTenantProviderHandler implements EventHandler {

	private static final String KEY_PROVIDER_TENANT_ID_IAS = "app_tid";
	private static final String KEY_PROVIDER_TENANT_ID_IAS_FALLBACK = "zone_uuid";
	private static final String KEY_PROVIDER_TENANT_ID_XSUAA = "tenantid";
	private final String providerTenant;

	public IdentityTenantProviderHandler(Optional<ServiceBinding> iasBinding, Optional<ServiceBinding> xsuaaBinding) {
		// ias is treated with priority
		if(iasBinding.isPresent()) {
			Map<String, Object> credentials = iasBinding.get().getCredentials();
			if(credentials.containsKey(KEY_PROVIDER_TENANT_ID_IAS)) {
				providerTenant = (String) credentials.get(KEY_PROVIDER_TENANT_ID_IAS);
			} else {
				providerTenant = (String) credentials.get(KEY_PROVIDER_TENANT_ID_IAS_FALLBACK);
			}
		} else if(xsuaaBinding.isPresent()) {
			providerTenant = (String) xsuaaBinding.get().getCredentials().get(KEY_PROVIDER_TENANT_ID_XSUAA);
		} else {
			providerTenant = null;
		}
	}

	@On
	@HandlerOrder(OrderConstants.On.FEATURE)
	public void readProviderTenant(ReadProviderTenantEventContext context) {
		if (providerTenant != null) {
			context.setResult(providerTenant);
		}
	}

}
