/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.identity;

import com.sap.cds.feature.identity.IdentityTenantProviderHandler;
import com.sap.cds.feature.identity.IdentityUserInfoProvider;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.runtime.UserInfoProvider;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(IdentityConfiguration.class);

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        this.identityConfigured(configurer, (iasBinding, xsuaaBinding) -> configurer.eventHandler((Object)new IdentityTenantProviderHandler((Optional<ServiceBinding>)iasBinding, (Optional<ServiceBinding>)xsuaaBinding)));
    }

    public void providers(CdsRuntimeConfigurer configurer) {
        this.identityConfigured(configurer, (iasBinding, xsuaaBinding) -> {
            logger.info("Loaded feature 'IdentityUserInfoProvider' (IAS: {}, XSUAA: {})", (Object)iasBinding.flatMap(ServiceBinding::getName).orElse("<none>"), (Object)xsuaaBinding.flatMap(ServiceBinding::getName).orElse("<none>"));
            configurer.provider((UserInfoProvider)new IdentityUserInfoProvider(configurer.getCdsRuntime(), (Optional<ServiceBinding>)iasBinding, (Optional<ServiceBinding>)xsuaaBinding));
        });
    }

    private void identityConfigured(CdsRuntimeConfigurer configurer, BiConsumer<Optional<ServiceBinding>, Optional<ServiceBinding>> configure) {
        XsuaaUtils xsuaaUtils = new XsuaaUtils(configurer.getCdsRuntime());
        if (xsuaaUtils.identityAuthenticationConfigured()) {
            XsuaaUtils.AuthenticationType authType = xsuaaUtils.configuredAuthenticationType();
            switch (authType) {
                case IAS: {
                    configure.accept(xsuaaUtils.getIasServiceBindings().stream().findFirst(), Optional.empty());
                    break;
                }
                case IAS_XSUAA: {
                    configure.accept(xsuaaUtils.getIasServiceBindings().stream().findFirst(), xsuaaUtils.getXsuaaServiceBindings().stream().findFirst());
                    break;
                }
                case XSUAA: {
                    configure.accept(Optional.empty(), xsuaaUtils.getXsuaaServiceBindings().stream().findFirst());
                }
            }
        }
    }
}

