/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.identity;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.authentication.JwtTokenAuthenticationInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.UserInfoProvider;
import com.sap.cds.services.utils.ClassMethods;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.security.json.JsonParsingException;
import com.sap.cloud.security.token.GrantType;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaToken;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityUserInfoProvider
implements UserInfoProvider {
    private static final Logger logger = LoggerFactory.getLogger(IdentityUserInfoProvider.class);
    private final CdsRuntime runtime;
    private final ServiceBinding iasBinding;
    private final ServiceBinding xsuaaBinding;
    private static final String SYSTEM_USER_NAME = "system";
    private static final String SYSTEM_INTERNAL_USER_NAME = "system-internal";

    public IdentityUserInfoProvider(CdsRuntime runtime, Optional<ServiceBinding> iasBinding, Optional<ServiceBinding> xsuaaBinding) {
        this.runtime = runtime;
        this.xsuaaBinding = xsuaaBinding.orElse(null);
        this.iasBinding = iasBinding.orElse(null);
    }

    public UserInfo get() {
        AuthenticationInfo authenticationInfo = this.runtime.getProvidedAuthenticationInfo();
        if (authenticationInfo != null && authenticationInfo.is(JwtTokenAuthenticationInfo.class)) {
            try {
                JwtTokenAuthenticationInfo accessToken = (JwtTokenAuthenticationInfo)authenticationInfo.as(JwtTokenAuthenticationInfo.class);
                Token token = Token.create((String)accessToken.getToken());
                logger.debug("Creating UserInfo based on token {}", (Object)token);
                switch (token.getService()) {
                    case IAS: {
                        IasUserInfoImpl iasUser = new IasUserInfoImpl(token);
                        logger.debug("Resolved {}", (Object)iasUser);
                        return iasUser;
                    }
                    case XSUAA: {
                        XsuaaUserInfoImpl xsuaaUser = new XsuaaUserInfoImpl((XsuaaToken)token);
                        logger.debug("Resolved {}", (Object)xsuaaUser);
                        return xsuaaUser;
                    }
                }
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.UNAUTHORIZED, new Object[0]);
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.UNAUTHORIZED, new Object[]{e});
            }
        }
        return null;
    }

    private class IasUserInfoImpl
    implements UserInfo {
        private final Token token;
        private final Map<String, List<String>> attributes;
        private final boolean isSystemUser;
        private final boolean isInternalUser;
        private Set<String> roles = Collections.emptySet();
        private static final String BINDING_CLIENT_ID = "clientid";
        private static final String SPECIAL_ATTRIBUTE_TENANT = "tenant";
        private static final String CLAIM_IAS_APIS = "ias_apis";
        private static final Set<String> KNOWN_CLAIMS = new HashSet<String>(Arrays.asList("ias_iss", "iss", "exp", "aud", "nbf", "sub", "user_uuid", "zone_uuid", "app_tid", "azp", "cnf", "x5t#S256", "iat", "jti"));

        IasUserInfoImpl(Token token) {
            this.token = token;
            this.attributes = token.getClaims().entrySet().stream().filter(e -> !KNOWN_CLAIMS.contains(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
                try {
                    return token.getClaimAsStringList((String)e.getKey());
                }
                catch (JsonParsingException ex) {
                    return Collections.singletonList(token.getClaimAsString((String)e.getKey()));
                }
            }));
            this.attributes.put(SPECIAL_ATTRIBUTE_TENANT, Collections.singletonList(this.getTenant()));
            List aud = token.getClaimAsStringList("aud");
            String azp = token.getClaimAsString("azp");
            if (azp == null && aud.size() == 1) {
                azp = (String)aud.get(0);
            }
            this.isSystemUser = azp.equals(token.getClaimAsString("sub"));
            boolean bl = this.isInternalUser = this.isSystemUser && azp.equals(IdentityUserInfoProvider.this.iasBinding.getCredentials().get(BINDING_CLIENT_ID));
            if (IdentityUserInfoProvider.this.runtime.getEnvironment().getCdsProperties().getSecurity().getIdentity().isExposePlansAsRoles()) {
                List servicePlans;
                this.roles = new HashSet<String>();
                if (token.hasClaim(CLAIM_IAS_APIS)) {
                    this.roles.addAll(token.getClaimAsStringList(CLAIM_IAS_APIS).stream().map(String::trim).collect(Collectors.toSet()));
                }
                if ((servicePlans = SecurityContext.getServicePlans()) != null) {
                    this.roles.addAll(servicePlans.stream().map(String::trim).collect(Collectors.toSet()));
                }
            }
        }

        public boolean isSystemUser() {
            return this.isSystemUser;
        }

        public boolean isInternalUser() {
            return this.isInternalUser;
        }

        public String getId() {
            return this.token.getClaimAsString("user_uuid");
        }

        public String getTenant() {
            return this.token.getZoneId();
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public String getName() {
            if (this.isInternalUser) {
                return IdentityUserInfoProvider.SYSTEM_INTERNAL_USER_NAME;
            }
            if (this.isSystemUser) {
                return IdentityUserInfoProvider.SYSTEM_USER_NAME;
            }
            return this.token.getClaimAsString("sub");
        }

        public boolean isAuthenticated() {
            return true;
        }

        public boolean isPrivileged() {
            return false;
        }

        public Map<String, List<String>> getAttributes() {
            return this.attributes;
        }

        public Map<String, Object> getAdditionalAttributes() {
            return this.token.getClaims();
        }

        public String toString() {
            return MessageFormat.format("IasUserInfo [id=''{0}'', name=''{1}'', roles=''{2}'', attributes=''{3}''", this.getId(), this.getName(), this.getRoles(), this.getAttributes());
        }
    }

    private class XsuaaUserInfoImpl
    implements UserInfo {
        private final XsuaaToken token;
        private final String name;
        private final boolean isSystemUser;
        private final boolean isInternalUser;
        private final Set<String> roles;
        private final Map<String, List<String>> attributes;
        private final Map<String, Object> additionalAttributes;
        private static final String SPECIAL_ATTRIBUTE_LOGON_NAME = "logonName";
        private static final String SPECIAL_ATTRIBUTE_TENANT = "tenant";
        private static final String EXTENSION_ATTRIBUTES = "ext_attr";
        private static final String BINDING_CLIENT_ID = "clientid";
        private static final String SERVICEINSTANCEID_ATTRIBUTE = "serviceinstanceid";
        private static final String SPECIAL_ATTRIBUTE_SERVICEINSTANCEID = "ext_attr.serviceinstanceid";
        private final Set<String> KNOWN_CLAIMS = new HashSet<String>(Arrays.asList("user_name", "zid", "user_id", "scope", "xs.user.attributes", "xs.system.attributes", "grant_type", "client_id"));
        private final Set<GrantType> SYSTEM_USER_GRANTS = new HashSet<GrantType>(Arrays.asList(GrantType.CLIENT_CREDENTIALS, GrantType.CLIENT_X509));

        private XsuaaUserInfoImpl(XsuaaToken token) {
            this.token = token;
            this.isSystemUser = this.SYSTEM_USER_GRANTS.contains(token.getGrantType());
            boolean bl = this.isInternalUser = this.isSystemUser && token.getClientId() != null && token.getClientId().equals(IdentityUserInfoProvider.this.xsuaaBinding.getCredentials().get(BINDING_CLIENT_ID));
            this.name = this.isInternalUser ? IdentityUserInfoProvider.SYSTEM_INTERNAL_USER_NAME : (this.isSystemUser ? IdentityUserInfoProvider.SYSTEM_USER_NAME : token.getClaimAsString("user_name"));
            String scopePrefix = (String)IdentityUserInfoProvider.this.xsuaaBinding.getCredentials().get("xsappname") + ".";
            this.roles = token.getScopes().stream().map(scope -> {
                int pos = scope.indexOf(scopePrefix);
                if (pos >= 0) {
                    return scope.substring(pos + scopePrefix.length());
                }
                return scope;
            }).collect(Collectors.toSet());
            this.attributes = new TreeMap<String, List<String>>();
            Map userAttributes = (Map)token.getClaims().get("xs.user.attributes");
            if (userAttributes != null) {
                this.attributes.putAll(userAttributes);
            }
            this.attributes.put(SPECIAL_ATTRIBUTE_TENANT, Collections.singletonList(token.getZoneId()));
            String serviceInstanceId = token.getAttributeFromClaimAsString(EXTENSION_ATTRIBUTES, SERVICEINSTANCEID_ATTRIBUTE);
            if (serviceInstanceId != null) {
                this.attributes.put(SPECIAL_ATTRIBUTE_SERVICEINSTANCEID, Collections.singletonList(serviceInstanceId));
            }
            this.additionalAttributes = new HashMap<String, Object>();
            this.additionalAttributes.put("givenName", token.getClaimAsString("given_name"));
            this.additionalAttributes.put("familyName", token.getClaimAsString("family_name"));
            this.additionalAttributes.put("subDomain", token.getAttributeFromClaimAsString(EXTENSION_ATTRIBUTES, "zdn"));
            token.getClaims().entrySet().stream().filter(entry -> !this.KNOWN_CLAIMS.contains(entry.getKey())).forEach(entry -> this.additionalAttributes.put((String)entry.getKey(), entry.getValue()));
            if (!this.isSystemUser) {
                this.additionalAttributes.put(SPECIAL_ATTRIBUTE_LOGON_NAME, token.getPrincipal().getName());
            }
        }

        public String getId() {
            return this.token.getClaimAsString("user_id");
        }

        public String getName() {
            return this.name;
        }

        public String getTenant() {
            return this.token.getZoneId();
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public boolean isSystemUser() {
            return this.isSystemUser;
        }

        public boolean isInternalUser() {
            return this.isInternalUser;
        }

        public boolean isAuthenticated() {
            return true;
        }

        public boolean isPrivileged() {
            return false;
        }

        public Map<String, List<String>> getAttributes() {
            return this.attributes;
        }

        public Map<String, Object> getAdditionalAttributes() {
            return this.additionalAttributes;
        }

        public <T extends UserInfo> T as(Class<T> userInfoClazz) {
            return (T)((UserInfo)ClassMethods.as(userInfoClazz, UserInfo.class, (Object)this, this::getAdditionalAttributes));
        }

        public String toString() {
            return MessageFormat.format("XsuaaUserInfo [id=''{0}'', name=''{1}'', roles=''{2}'', attributes=''{3}''", this.getId(), this.getName(), this.getRoles(), this.getAttributes());
        }
    }
}

