/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.transaction;

import java.util.UUID;

import com.sap.cds.services.transaction.TransactionManager;
import com.sap.cds.transaction.spi.ContainerTransactionManager;

// adapting the cds4j default transaction manager
public class LocalTransactionManager implements TransactionManager {

	private final ContainerTransactionManager cds4jTxMgr;
	private final String name = "local-" + UUID.randomUUID().toString();

	public LocalTransactionManager(ContainerTransactionManager cds4jTxMgr) {
		this.cds4jTxMgr = cds4jTxMgr;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public boolean isActive() {
		return cds4jTxMgr.isActive();
	}

	@Override
	public void begin() {
		cds4jTxMgr.begin();
	}

	@Override
	public void commit() {
		cds4jTxMgr.commit();
	}

	@Override
	public void rollback() {
		cds4jTxMgr.rollback();
	}

	@Override
	public boolean isRollbackOnly() {
		return cds4jTxMgr.isRollbackOnly();
	}

	@Override
	public void setRollbackOnly() {
		cds4jTxMgr.setRollbackOnly();
	}

}
