/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.services.Service;
import com.sap.cds.services.impl.persistence.JdbcPersistenceService;
import com.sap.cds.services.impl.transaction.LocalTransactionManager;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.transaction.TransactionManager;
import com.sap.cds.transaction.impl.LocalTransactionManagerFactory;
import java.sql.Connection;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class JdbcPersistenceServiceConfiguration
implements CdsRuntimeConfiguration {
    private final Supplier<Connection> connectionSupplier;
    private final TransactionManager txMgr;
    private JdbcPersistenceService service;

    public static JdbcPersistenceServiceConfiguration create(DataSource dataSource) {
        LocalTransactionManagerFactory txMgrFactory = new LocalTransactionManagerFactory(dataSource);
        return JdbcPersistenceServiceConfiguration.create(txMgrFactory.getConnectionSupplier(), new LocalTransactionManager(txMgrFactory.getTransactionManger()));
    }

    public static JdbcPersistenceServiceConfiguration create(Supplier<Connection> connectionSupplier, TransactionManager txMgr) {
        return new JdbcPersistenceServiceConfiguration(connectionSupplier, txMgr);
    }

    private JdbcPersistenceServiceConfiguration(Supplier<Connection> connectionSupplier, TransactionManager txMgr) {
        this.connectionSupplier = connectionSupplier;
        this.txMgr = txMgr;
    }

    public JdbcPersistenceService getService(CdsRuntime runtime) {
        if (this.service == null) {
            this.service = new JdbcPersistenceService("PersistenceService$Default", this.connectionSupplier, this.txMgr, runtime);
        }
        return this.service;
    }

    public void services(CdsRuntimeConfigurer configurer) {
        configurer.service((Service)this.getService(configurer.getCdsRuntime()));
    }
}

