/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.persistence;

import java.sql.Connection;
import java.util.function.Supplier;

import javax.sql.DataSource;

import com.sap.cds.services.impl.transaction.LocalTransactionManager;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.transaction.TransactionManager;
import com.sap.cds.transaction.impl.LocalTransactionManagerFactory;

public class JdbcPersistenceServiceConfiguration implements CdsRuntimeConfiguration {

	public static JdbcPersistenceServiceConfiguration create(DataSource dataSource) {
		LocalTransactionManagerFactory txMgrFactory = new LocalTransactionManagerFactory(dataSource);
		return create(txMgrFactory.getConnectionSupplier(), new LocalTransactionManager(txMgrFactory.getTransactionManger()));
	}

	public static JdbcPersistenceServiceConfiguration create(Supplier<Connection> connectionSupplier, TransactionManager txMgr) {
		return new JdbcPersistenceServiceConfiguration(connectionSupplier, txMgr);
	}

	private final Supplier<Connection> connectionSupplier;
	private final TransactionManager txMgr;
	private JdbcPersistenceService service;

	private JdbcPersistenceServiceConfiguration(Supplier<Connection> connectionSupplier, TransactionManager txMgr) {
		this.connectionSupplier = connectionSupplier;
		this.txMgr = txMgr;
	}

	public JdbcPersistenceService createOrGetService(CdsRuntimeConfigurer configurer) {
		if(service == null) {
			service = new JdbcPersistenceService(PersistenceService.DEFAULT_NAME, connectionSupplier, txMgr, configurer.getCdsRuntime());
			configurer.service(service);
		}
		return service;
	}

	@Override
	public void services(CdsRuntimeConfigurer configurer) {
		createOrGetService(configurer);
	}

}
