package com.sap.cds.services.impl.persistence;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.feature.config.pojo.CdsProperties;

class JdbcDataStoreConfiguration implements DataStoreConfiguration {

	private final CdsProperties cdsProperties;

	JdbcDataStoreConfiguration(CdsProperties cdsProperties) {
		this.cdsProperties = cdsProperties;
	}

	@Override
	public String getProperty(String key, String defaultValue) {
		switch (key) {
			case IGNORE_LOCALE_ON_HANA:
				return Boolean.toString(cdsProperties.getSql().getHana().isIgnoreLocale());
			case SUPPORTED_LOCALES:
				return cdsProperties.getSql().getSupportedLocales();
			case IGNORE_VIRTUAL_ELEMENTS:
				return Boolean.toString(cdsProperties.getSql().isIgnoreVirtualElements());
			case USE_LOCALIZED_VIEW_SEARCH_RESOLVER:
				return Boolean.toString(cdsProperties.getSql().getSearch().isUseLocalizedView());
			default:
				/*
				 * Once a property is part of CdsProperties the default is part of CdsProperties. Only if the
				 * key is unknown the default value from the method parameters is used.
				 */
				return defaultValue;
		}
	}
}
