package com.sap.cds.services.impl.persistence;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.services.environment.CdsProperties;

class JdbcDataStoreConfiguration implements DataStoreConfiguration {

	private final CdsProperties cdsProperties;

	JdbcDataStoreConfiguration(CdsProperties cdsProperties) {
		this.cdsProperties = cdsProperties;
	}

	@Override
	public String getProperty(String key) {
		switch (key) {
			case DOCSTORE_INTEGRATION_ENABLED:
				return Boolean.toString(cdsProperties.getSql().getHana().getDocstore().isEnabled());
			case IGNORE_LOCALE_ON_HANA:
				return Boolean.toString(cdsProperties.getSql().getHana().isIgnoreLocale());
			case SUPPORTED_LOCALES:
				return cdsProperties.getSql().getSupportedLocales();
			case IGNORE_VIRTUAL_ELEMENTS:
				return Boolean.toString(cdsProperties.getSql().isIgnoreVirtualElements());
			case MAX_BATCH_SIZE:
				return Integer.toString(cdsProperties.getSql().getMaxBatchSize());
			case USE_LOCALIZED_VIEW_SEARCH_RESOLVER:
				return Boolean.toString(cdsProperties.getSql().getSearch().isUseLocalizedView());
			case LOG_CQN_VALUES:
				return Boolean.toString(cdsProperties.getSecurity().isLogPotentiallySensitive());
			default:
				/*
				 * Once a property is part of CdsProperties the default is part of
				 * CdsProperties. Only if the key is unknown.
				 */
				return null;
		}
	}
}
