/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.services.environment.CdsProperties;

class JdbcDataStoreConfiguration
implements DataStoreConfiguration {
    private final CdsProperties cdsProperties;

    JdbcDataStoreConfiguration(CdsProperties cdsProperties) {
        this.cdsProperties = cdsProperties;
    }

    public String getProperty(String key) {
        switch (key) {
            case "cds.sql.hana.docstore": {
                return Boolean.toString(this.cdsProperties.getSql().getHana().getDocstore().isEnabled());
            }
            case "cds.sql.hana.ignore-locale": {
                return Boolean.toString(this.cdsProperties.getSql().getHana().isIgnoreLocale());
            }
            case "supported_locales": {
                return this.cdsProperties.getSql().getSupportedLocales();
            }
            case "cds.sql.ignore-virtual-elements": {
                return Boolean.toString(this.cdsProperties.getSql().isIgnoreVirtualElements());
            }
            case "cds.sql.max-batch-size": {
                return Integer.toString(this.cdsProperties.getSql().getMaxBatchSize());
            }
            case "cds.sql.search.use-localized-view": {
                return Boolean.toString(this.cdsProperties.getSql().getSearch().isUseLocalizedView());
            }
            case "cds.ql.logging.log-values": {
                return Boolean.toString(this.cdsProperties.getSecurity().isLogPotentiallySensitive());
            }
        }
        return null;
    }
}

