/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.persistence;

import java.util.stream.Collectors;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.services.environment.CdsProperties;

class JdbcDataStoreConfiguration implements DataStoreConfiguration {

	private final CdsProperties cdsProperties;

	JdbcDataStoreConfiguration(CdsProperties cdsProperties) {
		this.cdsProperties = cdsProperties;
	}

	@Override
	@SuppressWarnings("deprecation")
	public String getProperty(String key) {
		switch (key) {
			case DOCSTORE_INTEGRATION_ENABLED:
				return Boolean.toString(cdsProperties.getSql().getHana().getDocstore().isEnabled());
			case COLLATE:
				return cdsProperties.getSql().getCollate();
			case IGNORE_LOCALE_ON_HANA:
				return Boolean.toString(cdsProperties.getSql().getHana().isIgnoreLocale());
			case SUPPORTED_LOCALES:
				return cdsProperties.getSql().getSupportedLocales().stream().collect(Collectors.joining(","));
			case MAX_BATCH_SIZE:
				return Integer.toString(cdsProperties.getSql().getMaxBatchSize());
			case SEARCH_MODE:
				return cdsProperties.getSql().getSearch().getMode();
			case INLINE_COUNT:
				return cdsProperties.getSql().getInlineCount().getMode();
			case LOG_CQN_VALUES:
				return Boolean.toString(cdsProperties.getSecurity().isLogPotentiallySensitive());
			case HANA_COMPATIBILITY_MODE:
				return HANA_COMPATIBILITY_MODE_HEX.equalsIgnoreCase(cdsProperties.getSql().getHana().getOptimizationMode())
						? HANA_COMPATIBILITY_MODE_HEX
						: HANA_COMPATIBILITY_MODE_LEGACY;
			case SEARCH_HANA_FUZZY:
				return Boolean.toString(cdsProperties.getSql().getHana().getSearch().isFuzzy());
			case SEARCH_HANA_FUZZINESS:
				return cdsProperties.getSql().getHana().getSearch().getFuzzinessThreshold().toString();
			default:
				/*
				 * Once a property is part of CdsProperties the default is part of
				 * CdsProperties. Only if the key is unknown.
				 */
				return null;
		}
	}
}
