/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.services.environment.CdsProperties;
import java.util.stream.Collectors;

class JdbcDataStoreConfiguration
implements DataStoreConfiguration {
    private final CdsProperties cdsProperties;

    JdbcDataStoreConfiguration(CdsProperties cdsProperties) {
        this.cdsProperties = cdsProperties;
    }

    public String getProperty(String key) {
        switch (key) {
            case "cds.sql.hana.docstore": {
                return Boolean.toString(this.cdsProperties.getSql().getHana().getDocstore().isEnabled());
            }
            case "cds.sql.collate": {
                return this.cdsProperties.getSql().getCollate();
            }
            case "cds.sql.hana.ignore-locale": {
                return Boolean.toString(this.cdsProperties.getSql().getHana().isIgnoreLocale());
            }
            case "supported_locales": {
                return this.cdsProperties.getSql().getSupportedLocales().stream().collect(Collectors.joining(","));
            }
            case "cds.sql.max-batch-size": {
                return Integer.toString(this.cdsProperties.getSql().getMaxBatchSize());
            }
            case "cds.sql.search.mode": {
                return this.cdsProperties.getSql().getSearch().getMode();
            }
            case "cds.sql.inlineCount": {
                return this.cdsProperties.getSql().getInlineCount().getMode();
            }
            case "cds.ql.logging.log-values": {
                return Boolean.toString(this.cdsProperties.getSecurity().isLogPotentiallySensitive());
            }
            case "cds.sql.hana.compatibilityMode": {
                return "hex".equalsIgnoreCase(this.cdsProperties.getSql().getHana().getOptimizationMode()) ? "hex" : "legacy";
            }
        }
        return null;
    }
}

