/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CdsException;
import com.sap.cds.CdsLockTimeoutException;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.NotNullConstraintException;
import com.sap.cds.Result;
import com.sap.cds.UniqueConstraintException;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.changeset.ChangeSetMember;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.persistence.JdbcDataStoreConfiguration;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.transaction.ChangeSetMemberDelegate;
import com.sap.cds.services.transaction.TransactionManager;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.OpenTelemetryUtils;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.services.AbstractCqnService;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPersistenceService
extends AbstractCqnService
implements PersistenceService {
    private static final Logger logger = LoggerFactory.getLogger(JdbcPersistenceService.class);
    private final TenantAwareCache<CdsDataStoreConnector, CdsModel> cachedConnectors;
    private final Map<ChangeSetContext, CachedCdsDataStore> cachedDataStores = new ConcurrentHashMap<ChangeSetContext, CachedCdsDataStore>();
    private final TransactionManager txMgr;

    public JdbcPersistenceService(String name, Supplier<Connection> connectionSupplier, final TransactionManager txMgr, CdsRuntime runtime) {
        super(name, runtime);
        this.txMgr = txMgr;
        com.sap.cds.transaction.TransactionManager cds4jTxMgr = new com.sap.cds.transaction.TransactionManager(){

            public boolean isActive() {
                ChangeSetContextSPI changeSetContext = (ChangeSetContextSPI)ChangeSetContext.getCurrent();
                boolean activeChangeSet = changeSetContext != null && changeSetContext.hasChangeSetMember(txMgr.getName());
                boolean activeTxMgr = txMgr.isActive();
                return activeChangeSet || activeTxMgr;
            }

            public void setRollbackOnly() {
                ChangeSetContext changeSetContext = ChangeSetContext.getCurrent();
                if (changeSetContext != null) {
                    changeSetContext.markForCancel();
                } else {
                    txMgr.setRollbackOnly();
                }
            }
        };
        this.cachedConnectors = TenantAwareCache.create(() -> CdsDataStoreConnector.createJdbcConnector((CdsModel)RequestContext.getCurrent((CdsRuntime)runtime).getModel(), (com.sap.cds.transaction.TransactionManager)cds4jTxMgr).connection(connectionSupplier).config((DataStoreConfiguration)new JdbcDataStoreConfiguration(runtime.getEnvironment().getCdsProperties())).build(), (CdsRuntime)runtime);
    }

    @Before
    @HandlerOrder(value=-12000)
    protected void ensureTransaction(EventContext context) {
        ChangeSetContextSPI changeSetContext = (ChangeSetContextSPI)context.getChangeSetContext();
        if (!changeSetContext.hasChangeSetMember(this.txMgr.getName())) {
            changeSetContext.register((ChangeSetMember)new ChangeSetMemberDelegate(this.txMgr));
            try {
                this.txMgr.begin();
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TRANSACTION_INITIALIZATION_FAILED, new Object[]{e});
            }
        }
        try {
            this.getCdsDataStore().setSessionContext(SessionContextUtils.toSessionContext((EventContext)context));
        }
        catch (CdsException e) {
            logger.warn("Not supported to set the locale on the connection session", (Throwable)e);
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultRead(CdsReadEventContext context) {
        return this.checkExceptionAndOtelSpan(() -> this.getCdsDataStore().execute(context.getCqn(), context.getCqnNamedValues()), "SELECT", context.getTarget(), (CqnStatement)context.getCqn());
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultCreate(CdsCreateEventContext context) {
        return this.checkExceptionAndOtelSpan(() -> this.getCdsDataStore().execute(context.getCqn()), "INSERT", context.getTarget(), (CqnStatement)context.getCqn());
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultUpsert(CdsUpsertEventContext context) {
        return this.checkExceptionAndOtelSpan(() -> this.getCdsDataStore().execute(context.getCqn()), "UPSERT", context.getTarget(), (CqnStatement)context.getCqn());
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultUpdate(CdsUpdateEventContext context) {
        return this.checkExceptionAndOtelSpan(() -> this.getCdsDataStore().execute(context.getCqn(), context.getCqnValueSets()), "UPDATE", context.getTarget(), (CqnStatement)context.getCqn());
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultDelete(CdsDeleteEventContext context) {
        return this.checkExceptionAndOtelSpan(() -> this.getCdsDataStore().execute(context.getCqn(), context.getCqnValueSets()), "DELETE", context.getTarget(), (CqnStatement)context.getCqn());
    }

    public CdsDataStore getCdsDataStore() {
        if (!ChangeSetContext.isActive()) {
            return ((CdsDataStoreConnector)this.cachedConnectors.findOrCreate()).connect();
        }
        final ChangeSetContext context = ChangeSetContext.getCurrent();
        String currentTenant = RequestContext.getCurrent((CdsRuntime)this.runtime).getUserInfo().getTenant();
        CachedCdsDataStore cachedDataStore = this.cachedDataStores.get(context);
        if (cachedDataStore == null) {
            cachedDataStore = new CachedCdsDataStore(((CdsDataStoreConnector)this.cachedConnectors.findOrCreate()).connect(), currentTenant);
            context.register(new ChangeSetListener(){

                public void afterClose(boolean completed) {
                    JdbcPersistenceService.this.cachedDataStores.remove(context);
                }
            });
            this.cachedDataStores.put(context, cachedDataStore);
        } else if (!Objects.equals(cachedDataStore.getTenant(), currentTenant)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TRANSACTION_TENANT_MISMATCH, new Object[]{cachedDataStore.getTenant(), currentTenant});
        }
        return cachedDataStore.getCdsDataStore();
    }

    @VisibleForTesting
    Result checkExceptionAndOtelSpan(Supplier<Result> supplier, String cqnOperation, CdsEntity targetEntity, CqnStatement cqnStatement) {
        Optional span = OpenTelemetryUtils.createSpan((OpenTelemetryUtils.CdsSpanType)OpenTelemetryUtils.CdsSpanType.CQN);
        try {
            Result result;
            block14: {
                Scope scope = span.map(ImplicitContextKeyed::makeCurrent).orElse(null);
                try {
                    OpenTelemetryUtils.updateSpan((Optional)span, (CdsRuntime)this.runtime, (String)cqnOperation, (CdsEntity)targetEntity, (CqnStatement)cqnStatement, (String)"sql");
                    result = supplier.get();
                    if (scope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (UniqueConstraintException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNIQUE_CONSTRAINT_VIOLATED, new Object[]{e.getEntityName(), e});
                    }
                    catch (NotNullConstraintException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_REQUIRED, new Object[]{StringUtils.stringifyList((List)e.getElementNames()), e.getEntityName(), e});
                    }
                    catch (CdsLockTimeoutException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.LOCK_TIMEOUT, new Object[]{e.getDefinition().getQualifiedName(), e});
                    }
                    catch (CdsDataException | CqnValidationException e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CQN, new Object[]{e.getMessage(), e});
                    }
                }
                scope.close();
            }
            return result;
        }
        finally {
            OpenTelemetryUtils.endSpan((Optional)span);
        }
    }

    private static class CachedCdsDataStore {
        private final CdsDataStore cdsDataStore;
        private final String tenant;

        public CachedCdsDataStore(CdsDataStore cdsDataStore, String tenant) {
            this.cdsDataStore = cdsDataStore;
            this.tenant = tenant;
        }

        public CdsDataStore getCdsDataStore() {
            return this.cdsDataStore;
        }

        public String getTenant() {
            return this.tenant;
        }
    }
}

