/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.services.Service;
import com.sap.cds.services.impl.persistence.JdbcPersistenceService;
import com.sap.cds.services.impl.transaction.LocalTransactionManager;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.transaction.TransactionManager;
import com.sap.cds.transaction.impl.LocalTransactionManagerFactory;
import java.sql.Connection;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class JdbcPersistenceServiceConfiguration
implements CdsRuntimeConfiguration {
    private final String name;
    private final Supplier<Connection> connectionSupplier;
    private final TransactionManager txMgr;
    private JdbcPersistenceService service;

    public static JdbcPersistenceServiceConfiguration create(DataSource dataSource) {
        return JdbcPersistenceServiceConfiguration.create("PersistenceService$Default", dataSource);
    }

    public static JdbcPersistenceServiceConfiguration create(String name, DataSource dataSource) {
        LocalTransactionManagerFactory txMgrFactory = new LocalTransactionManagerFactory(dataSource);
        return JdbcPersistenceServiceConfiguration.create(name, txMgrFactory.getConnectionSupplier(), new LocalTransactionManager(name, txMgrFactory.getTransactionManger()));
    }

    public static JdbcPersistenceServiceConfiguration create(String name, Supplier<Connection> connectionSupplier, TransactionManager txMgr) {
        return new JdbcPersistenceServiceConfiguration(name, connectionSupplier, txMgr);
    }

    private JdbcPersistenceServiceConfiguration(String name, Supplier<Connection> connectionSupplier, TransactionManager txMgr) {
        this.name = name;
        this.connectionSupplier = connectionSupplier;
        this.txMgr = txMgr;
    }

    public JdbcPersistenceService createOrGetService(CdsRuntimeConfigurer configurer) {
        if (this.service == null) {
            this.service = new JdbcPersistenceService(this.name, this.connectionSupplier, this.txMgr, configurer.getCdsRuntime());
            configurer.service((Service)this.service);
        }
        return this.service;
    }

    public void services(CdsRuntimeConfigurer configurer) {
        this.createOrGetService(configurer);
    }
}

