/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.services.environment.CdsProperties;

class JdbcDataStoreConfiguration
implements DataStoreConfiguration {
    private final CdsProperties cdsProperties;

    JdbcDataStoreConfiguration(CdsProperties cdsProperties) {
        this.cdsProperties = cdsProperties;
    }

    public String getProperty(String key) {
        switch (key) {
            case "cds.sql.hana.docstore": {
                return Boolean.toString(this.cdsProperties.getSql().getHana().getDocstore().isEnabled());
            }
            case "cds.sql.collate": {
                return this.cdsProperties.getSql().getCollate();
            }
            case "cds.sql.hana.ignore-locale": {
                return Boolean.toString(this.cdsProperties.getSql().getHana().isIgnoreLocale());
            }
            case "cds.sql.max-batch-size": {
                return Integer.toString(this.cdsProperties.getSql().getMaxBatchSize());
            }
            case "cds.sql.search.mode": {
                return this.cdsProperties.getSql().getSearch().getMode();
            }
            case "cds.sql.runtimeView.mode": {
                return this.cdsProperties.getSql().getRuntimeView().getMode();
            }
            case "cds.sql.filteredView.mode": {
                return this.cdsProperties.getSql().getFilteredView().getMode();
            }
            case "cds.sql.toOnePath.mode": {
                return this.cdsProperties.getSql().getToOnePath().getMode();
            }
            case "cds.sql.inlineCount": {
                return this.cdsProperties.getSql().getInlineCount().getMode();
            }
            case "cds.ql.logging.log-values": {
                return Boolean.toString(this.cdsProperties.getSecurity().isLogPotentiallySensitive());
            }
            case "cds.sql.hana.compatibilityMode": {
                return "legacy".equalsIgnoreCase(this.cdsProperties.getSql().getHana().getOptimizationMode()) ? "legacy" : "hex";
            }
            case "cds.sql.hana.search.fuzzy": {
                return Boolean.toString(this.cdsProperties.getSql().getHana().getSearch().isFuzzy());
            }
            case "cds.sql.hana.search.fuzzinessThreshold": {
                return this.cdsProperties.getSql().getHana().getSearch().getFuzzinessThreshold().toString();
            }
        }
        return null;
    }
}

