/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.k8s;

import com.sap.cds.feature.k8s.K8sApplicationInfoProvider;
import com.sap.cds.feature.k8s.K8sServiceBindingProvider;
import com.sap.cds.services.environment.ApplicationInfoProvider;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sEnvironmentConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(K8sEnvironmentConfiguration.class);

    public void environment(CdsRuntimeConfigurer configurer) {
        CdsProperties.Environment.K8s config = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getEnvironment().getK8s();
        File secretRoot = new File(config.getSecretsPath());
        if (secretRoot != null && secretRoot.isDirectory() || config.getServiceBindings().size() > 0) {
            logger.info("Loaded feature 'K8s Platform Environment'");
            configurer.environment((ServiceBindingProvider)new K8sServiceBindingProvider(config, secretRoot));
            configurer.environment((ApplicationInfoProvider)new K8sApplicationInfoProvider());
        }
    }
}

