/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.k8s;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sServiceBindingProvider
implements ServiceBindingProvider {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(K8sServiceBindingProvider.class);
    private final CdsProperties.Environment.K8s config;
    private final File secretRoot;
    private List<ServiceBinding> serviceBindings;

    public K8sServiceBindingProvider(CdsProperties.Environment.K8s config, File secretRoot) {
        this.config = config;
        this.secretRoot = secretRoot;
    }

    public Stream<ServiceBinding> get() {
        if (this.serviceBindings == null) {
            ArrayList<ServiceBinding> theServiceBindings = new ArrayList<ServiceBinding>();
            if (this.secretRoot != null && this.secretRoot.isDirectory()) {
                Arrays.stream(this.secretRoot.listFiles()).filter(File::isDirectory).map(this::findServiceInstances).forEach(theServiceBindings::addAll);
            }
            for (CdsProperties.Environment.K8s.ServiceBindingConfig info : this.config.getServiceBindings().values()) {
                File serviceInstanceDirectory = new File(info.getSecretsPath());
                if (serviceInstanceDirectory.isDirectory()) {
                    theServiceBindings.add((ServiceBinding)DefaultServiceBinding.builder().copy(Collections.emptyMap()).withName(info.getName()).withServiceName(info.getService()).withServicePlan(info.getPlan()).withTags((Iterable)(info.getTags() != null ? info.getTags() : Collections.emptyList())).withCredentials(this.getCredentials(serviceInstanceDirectory)).build());
                    continue;
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_SECRETS_PATH, new Object[]{info.getSecretsPath(), info.getName()});
            }
            this.serviceBindings = theServiceBindings;
        }
        return this.serviceBindings.stream();
    }

    private List<ServiceBinding> findServiceInstances(File serviceDirectory) {
        return Arrays.stream(serviceDirectory.listFiles()).filter(File::isDirectory).map(instanceDirectory -> {
            logger.debug("Found binding for service '{}' in instance directory '{}'", (Object)serviceDirectory.getName(), (Object)instanceDirectory.getAbsolutePath());
            return DefaultServiceBinding.builder().copy(Collections.emptyMap()).withName(instanceDirectory.getName()).withServiceName(serviceDirectory.getName()).withCredentials(this.getCredentials((File)instanceDirectory)).build();
        }).collect(Collectors.toList());
    }

    private Map<String, Object> getCredentials(File serviceInstanceDirectory) {
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        Arrays.stream(serviceInstanceDirectory.listFiles()).filter(File::isFile).filter(propertyFile -> !propertyFile.getName().startsWith(".")).forEach(propertyFile -> credentials.put(propertyFile.getName(), this.getValue((File)propertyFile)));
        return credentials;
    }

    private Object getValue(File propertyFile) {
        String content;
        try {
            content = new String(Files.readAllBytes(propertyFile.toPath()), StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PROPERTY_FILE, new Object[]{propertyFile.getAbsolutePath(), e});
        }
        if (content.startsWith("[") || content.startsWith("{")) {
            try {
                return mapper.readValue(content, (TypeReference)new TypeReference<Object>(){});
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return content;
    }
}

