/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.k8s;

import java.io.File;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.environment.CdsProperties.Environment.K8s;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class K8sEnvironmentConfiguration implements CdsRuntimeConfiguration {

	private static final Logger logger = LoggerFactory.getLogger(K8sEnvironmentConfiguration.class);

	@Override
	@SuppressWarnings("deprecation")
	public void environment(CdsRuntimeConfigurer configurer) {
		K8s config = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getEnvironment().getK8s();
		File secretRoot = new File(config.getSecretsPath());
		if((secretRoot != null && secretRoot.isDirectory()) || (config.getServiceBindings().size() > 0)) {
			logger.info("Loaded feature 'K8s Platform Environment'");
			configurer.environment(new K8sServiceBindingProvider(config, secretRoot));
			configurer.environment(new K8sApplicationInfoProvider());
		}
	}

}
