/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.k8s;

import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.environment.ApplicationInfoProvider;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

/**
 * The K8s based {@link ApplicationInfoProvider}.
 *
 * <p>As this information is not available on K8s, all methods throw an exception.
 */
public class K8sApplicationInfoProvider implements ApplicationInfoProvider {

  private static final ApplicationInfo applicationInfo = new K8sApplicationInfo();

  @Override
  public ApplicationInfo get() {
    return applicationInfo;
  }

  private static class K8sApplicationInfo implements ApplicationInfo {

    @Override
    public String getId() {
      throw new ErrorStatusException(CdsErrorStatuses.APP_PROPERTIES_UNSUPPORTED);
    }

    @Override
    public String getName() {
      throw new ErrorStatusException(CdsErrorStatuses.APP_PROPERTIES_UNSUPPORTED);
    }

    @Override
    public String getUrl() {
      throw new ErrorStatusException(CdsErrorStatuses.APP_PROPERTIES_UNSUPPORTED);
    }
  }
}
