/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.k8s;

import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.StringUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sEnvironmentConfiguration implements CdsRuntimeConfiguration {

  private static final Logger logger = LoggerFactory.getLogger(K8sEnvironmentConfiguration.class);

  @Override
  public void environment(CdsRuntimeConfigurer configurer) {
    String bindingPath = System.getenv("SERVICE_BINDING_ROOT");
    if (StringUtils.isEmpty(bindingPath)) {
      bindingPath = "/etc/secrets/sapbtp";
    }
    if (new File(bindingPath).isDirectory()) {
      logger.info("Loaded feature 'K8s Platform Environment'");
      configurer.environment(new K8sApplicationInfoProvider());
    }
  }
}
