/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.kafka.client;

import com.sap.cds.feature.messaging.kafka.client.KafkaClientFactory;
import com.sap.cds.feature.messaging.kafka.client.KafkaMessagingConsumer;
import com.sap.cds.feature.messaging.kafka.client.KafkaMessagingProducer;
import com.sap.cds.feature.messaging.kafka.client.KafkaTopicAdminClient;
import com.sap.cds.feature.messaging.kafka.utils.KafkaServiceBinding;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Map;
import java.util.Objects;

public class DefaultKafkaClientFactory
implements KafkaClientFactory {
    private final String serviceName;
    private final String groupId;
    private final KafkaServiceBinding binding;
    private final CdsRuntime runtime;
    private final Map<String, String> connectionProperties;
    private final Map<String, Object> config;
    private KafkaTopicAdminClient topicAdminClient;
    private KafkaMessagingProducer producer;
    private KafkaMessagingConsumer consumer;

    DefaultKafkaClientFactory(String serviceName, String groupId, KafkaServiceBinding binding, Map<String, String> connectionProperties, Map<String, Object> config, CdsRuntime runtime) {
        this.serviceName = serviceName;
        this.groupId = groupId;
        this.binding = binding;
        this.connectionProperties = connectionProperties;
        this.config = config;
        this.runtime = runtime;
    }

    @Override
    public void startConsumer() {
        if (Objects.nonNull(this.consumer)) {
            this.consumer.start();
        }
    }

    @Override
    public void closeConsumer() throws InterruptedException {
        if (Objects.nonNull(this.consumer)) {
            this.consumer.close();
        }
    }

    @Override
    public void closeProducer() {
        if (Objects.nonNull(this.producer)) {
            this.producer.close();
        }
    }

    @Override
    public KafkaMessagingProducer getOrCreateProducer() {
        if (Objects.isNull(this.producer)) {
            this.producer = new KafkaMessagingProducer(this.binding, this.groupId, this.connectionProperties, this.config);
        }
        return this.producer;
    }

    @Override
    public KafkaMessagingConsumer getOrCreateConsumer() {
        if (Objects.isNull(this.consumer)) {
            this.consumer = new KafkaMessagingConsumer(this.serviceName, this.groupId, this.binding, this.connectionProperties, this.config, this.runtime);
        }
        return this.consumer;
    }

    @Override
    public KafkaTopicAdminClient getOrCreateTopicAdminClient() {
        if (Objects.isNull(this.topicAdminClient)) {
            this.topicAdminClient = new KafkaTopicAdminClient(this.binding, this.connectionProperties);
        }
        return this.topicAdminClient;
    }
}

