/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.kafka.client;

import com.google.common.collect.Lists;
import com.sap.cds.feature.messaging.kafka.utils.KafkaServiceBinding;
import com.sap.cds.feature.messaging.kafka.utils.KafkaUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.errors.TopicExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopicAdminClient {
    private static final Logger logger = LoggerFactory.getLogger(KafkaTopicAdminClient.class);
    private final AdminClient adminClient;
    private final Set<String> existingTopics;

    public KafkaTopicAdminClient(KafkaServiceBinding binding) {
        this.adminClient = KafkaAdminClient.create((Properties)KafkaUtils.getAdminProperties(binding));
        this.existingTopics = this.retrieveExistingTopics();
    }

    public void createTopicIfNotExisting(String topic) {
        if (!this.existingTopics.contains(topic)) {
            this.createTopic(topic);
        }
    }

    private void createTopic(String topic) {
        CreateTopicsOptions options = new CreateTopicsOptions();
        NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.empty());
        logger.info("Topic '{}' doesn't exist, creating it.", (Object)topic);
        try {
            this.adminClient.createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{newTopic}), options).all().get();
            this.existingTopics.add(topic);
            logger.debug("Kafka topic {} created with default configuration.", (Object)topic);
        }
        catch (TopicExistsException e) {
            this.existingTopics.add(topic);
            logger.debug("Kafka topic {} already exists.", (Object)topic);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error while creating the Kafka topic {}.", (Object)topic, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private Set<String> retrieveExistingTopics() {
        try {
            return new HashSet<String>((Collection)this.adminClient.listTopics(new ListTopicsOptions().listInternal(false)).names().get());
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("An error occurred while retrieving the existing Kafka topics. Performance might be affected when sending messages after the start of the service.", (Throwable)e);
            Thread.currentThread().interrupt();
            return new HashSet<String>();
        }
    }
}

