/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.kafka.client.deserializer;

import com.sap.cds.feature.messaging.kafka.client.deserializer.KafkaMessagingDeserializationException;
import com.sap.cds.feature.messaging.kafka.utils.KafkaUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class ErrorHandlingDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> delegate;

    public ErrorHandlingDeserializer(Deserializer<T> delegate) {
        this.delegate = delegate;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegate.configure(configs, isKey);
    }

    public T deserialize(String topic, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, data);
        }
        catch (Exception ex) {
            throw new KafkaMessagingDeserializationException(ex, ex.getMessage(), topic, Collections.emptyMap(), data);
        }
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, headers, data);
        }
        catch (Exception ex) {
            Map<String, String> headersMap = Arrays.stream(headers.toArray()).collect(Collectors.toMap(e -> e.key(), e -> KafkaUtils.toString(e.value())));
            throw new KafkaMessagingDeserializationException(ex, ex.getMessage(), topic, headersMap, data);
        }
    }
}

