/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.kafka.client;

import com.sap.cds.feature.messaging.kafka.utils.KafkaServiceBinding;
import com.sap.cds.feature.messaging.kafka.utils.KafkaUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMessagingProducer {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessagingProducer.class);
    private final KafkaProducer<String, String> producer;

    public KafkaMessagingProducer(KafkaServiceBinding binding, String groupId, Map<String, Object> config) {
        this.producer = new KafkaProducer(KafkaUtils.createMessageProducerProperties(binding, groupId, config));
    }

    public void close() {
        this.producer.close(Duration.of(10L, ChronoUnit.SECONDS));
    }

    public RecordMetadata publish(String topic, Integer partition, String objectKey, String data, Iterable<Header> headers) throws ExecutionException, InterruptedException, TimeoutException {
        ProducerRecord producerRecord = new ProducerRecord(topic, partition, (Object)objectKey, (Object)data, headers);
        RecordMetadata metadata = (RecordMetadata)this.producer.send(producerRecord).get(10L, TimeUnit.SECONDS);
        logger.debug("Sent message to topic '{}', partition '{}', offset '{}'", new Object[]{metadata.topic(), metadata.partition(), metadata.offset()});
        return metadata;
    }
}

