/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.kafka.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.HashMap;
import java.util.Map;

public class KafkaServiceBinding {
    private Map<String, ?> credentials;

    public KafkaServiceBinding(ServiceBinding binding) {
        this.credentials = binding.getCredentials();
    }

    public String getBootstrapServersAuthSSL() {
        return this.getBootstrapServers().get("brokers.auth_ssl");
    }

    private Map<String, String> getBootstrapServers() {
        if (this.credentials.containsKey("cluster") && this.credentials.get("cluster") instanceof Map) {
            return (Map)this.credentials.get("cluster");
        }
        if (this.credentials.containsKey("cluster.public") && this.credentials.get("cluster.public") instanceof Map) {
            return (Map)this.credentials.get("cluster.public");
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_KAFKA_CLUSTER_PROVIDED, new Object[0]);
    }

    public String getRootCertUrl() {
        return this.getUrls().get("certs");
    }

    public String getTokenUrl() {
        return this.getUrls().get("token");
    }

    private Map<String, String> getUrls() {
        if (!this.credentials.containsKey("urls")) {
            return new HashMap<String, String>();
        }
        return (Map)this.credentials.get("urls");
    }

    public String getUsername() {
        return (String)this.credentials.get("username");
    }

    public String getPassword() {
        return (String)this.credentials.get("password");
    }

    public String getTenant() {
        return (String)this.credentials.get("tenant");
    }
}

