/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.kafka.client;

import com.google.common.collect.Lists;
import com.sap.cds.feature.messaging.kafka.utils.KafkaServiceBinding;
import com.sap.cds.feature.messaging.kafka.utils.KafkaUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.errors.TopicExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopicAdminClient {
    private static final Logger logger = LoggerFactory.getLogger(KafkaTopicAdminClient.class);
    private final AdminClient adminClient;
    private final Set<String> existingTopics;

    public KafkaTopicAdminClient(KafkaServiceBinding binding, Map<String, String> connectionProperties) {
        this.adminClient = KafkaAdminClient.create((Properties)KafkaUtils.getAdminProperties(binding, connectionProperties));
        this.existingTopics = this.retrieveExistingTopics();
    }

    public void createTopicIfNotExisting(String topic) {
        if (!this.existingTopics.contains(topic)) {
            this.createTopic(topic);
        }
    }

    private void createTopic(String topic) {
        CreateTopicsOptions options = new CreateTopicsOptions();
        NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.empty());
        logger.info("Topic '{}' doesn't exist, creating it.", (Object)topic);
        try {
            this.adminClient.createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{newTopic}), options).all().get();
            this.existingTopics.add(topic);
            logger.debug("Kafka topic {} created with default configuration.", (Object)topic);
        }
        catch (TopicExistsException e) {
            this.existingTopics.add(topic);
            logger.debug("Kafka topic {} already exists.", (Object)topic);
        }
        catch (InterruptedException e) {
            logger.error("Error while emitting a message for topic '{}', thread interrupted.", (Object)topic, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.error("Error while emitting a message for topic '{}'.", (Object)topic, (Object)e);
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TOPIC_CREATION_FAILED, new Object[]{topic, e});
        }
    }

    private Set<String> retrieveExistingTopics() {
        try {
            return new HashSet<String>((Collection)this.adminClient.listTopics(new ListTopicsOptions().listInternal(false)).names().get());
        }
        catch (InterruptedException e) {
            logger.error("Error while reading topics, thread interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.warn("An error occurred while retrieving the existing Kafka topics. Performance might be affected when sending messages after the start of the service.", (Throwable)e);
        }
        return new HashSet<String>();
    }
}

