/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.kafka.utils;

import com.sap.cds.feature.messaging.kafka.utils.KafkaServiceBinding;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class TrustStoreUtilsMtls {
    private static final Pattern CLAIMS_PATTERN = Pattern.compile("^CN=([^,]*).*$");
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\sPRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\sPRIVATE\\s+KEY[^-]*-+", 2);
    private static final Pattern ENCRYPTED_KEY_PATTERN = Pattern.compile("-+BEGIN\\sENCRYPTED\\sPRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\sENCRYPTED\\sPRIVATE\\s+KEY[^-]*-+", 2);

    private TrustStoreUtilsMtls() {
    }

    public static String loadRootCertFromUrl(String rootCertUrl) throws IOException {
        URL url = new URL(rootCertUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            String string;
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "text/plain");
            conn.setRequestProperty("charset", "utf-8");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public static String createKeyStoreFromBinding(KafkaServiceBinding binding, String keyStorePass) throws CertificateException, IOException, InvalidKeySpecException, NoSuchAlgorithmException, KeyStoreException, InvalidAlgorithmParameterException, NoSuchPaddingException, InvalidKeyException {
        String clientCertChain = binding.getClientCert();
        String clientKey = binding.getClientKey();
        KeyEncryptionAlgorithm keyEncryptionAlgorithm = TrustStoreUtilsMtls.getKeyEncryptionAlgorithm(binding);
        KeyStore keyStore = TrustStoreUtilsMtls.createKeyStore(clientCertChain, clientKey, null, keyEncryptionAlgorithm);
        File keystoreFile = File.createTempFile("kafkaKeyStore", ".jks");
        try (FileOutputStream fos = new FileOutputStream(keystoreFile);){
            keyStore.store(fos, keyStorePass.toCharArray());
        }
        return keystoreFile.getAbsolutePath();
    }

    private static KeyStore createKeyStore(String clientCertChain, String privateKey, String keyPassword, KeyEncryptionAlgorithm keyEncryptionAlgorithm) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, CertificateException, KeyStoreException {
        PKCS8EncodedKeySpec encodedKeySpec = TrustStoreUtilsMtls.readPrivateKey(privateKey, null, keyEncryptionAlgorithm);
        List<X509Certificate> certificates = TrustStoreUtilsMtls.readCertificateChain(clientCertChain);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry(TrustStoreUtilsMtls.getSubject(certificates.get(0)), TrustStoreUtilsMtls.fromPKCS8EncodedKeySpec(encodedKeySpec), TrustStoreUtilsMtls.toCharArray(keyPassword), certificates.toArray(new Certificate[0]));
        return keyStore;
    }

    public static char[] toCharArray(String s) {
        return s != null ? s.toCharArray() : "".toCharArray();
    }

    private static PrivateKey fromPKCS8EncodedKeySpec(PKCS8EncodedKeySpec encodedKeySpec) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey key;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            key = keyFactory.generatePrivate(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ignore) {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            key = keyFactory.generatePrivate(encodedKeySpec);
        }
        return key;
    }

    private static List<X509Certificate> readCertificateChain(String clientCertChain) throws CertificateException {
        Matcher matcher = CERT_PATTERN.matcher(clientCertChain);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        int start = 0;
        while (matcher.find(start)) {
            byte[] buffer = TrustStoreUtilsMtls.base64Decode(matcher.group(1));
            certificates.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(buffer)));
            start = matcher.end();
        }
        return certificates;
    }

    private static PKCS8EncodedKeySpec readPrivateKey(String privateKey, String keyPassword, KeyEncryptionAlgorithm keyEncryptionAlgorithm) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        Matcher matcher = ENCRYPTED_KEY_PATTERN.matcher(privateKey);
        if (matcher.find()) {
            return TrustStoreUtilsMtls.readEncryptedPrivateKey(matcher.group(1), keyPassword, keyEncryptionAlgorithm);
        }
        matcher = KEY_PATTERN.matcher(privateKey);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Argument is not a private key");
        }
        byte[] decodedKey = TrustStoreUtilsMtls.base64Decode(matcher.group(1));
        return new PKCS8EncodedKeySpec(decodedKey);
    }

    private static PKCS8EncodedKeySpec readEncryptedPrivateKey(String privateKey, String keyPassword, KeyEncryptionAlgorithm keyEncryptionAlgorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (keyPassword == null || keyPassword.isEmpty()) {
            throw new IllegalArgumentException("Must have a keyPassword for encrypted private key");
        }
        if (keyEncryptionAlgorithm == null) {
            throw new IllegalArgumentException("Must have a keyEncryptionAlgorithm for encrypted private key");
        }
        byte[] decodedKey = TrustStoreUtilsMtls.base64Decode(privateKey);
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(decodedKey);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(keyEncryptionAlgorithm.toString());
        SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(keyPassword.toCharArray()));
        Cipher cipher = Cipher.getInstance(keyEncryptionAlgorithm.toString());
        cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
        return encryptedPrivateKeyInfo.getKeySpec(cipher);
    }

    private static KeyEncryptionAlgorithm getKeyEncryptionAlgorithm(KafkaServiceBinding binding) throws NoSuchAlgorithmException {
        String clientKeyAlg = binding.getClientKeyAlg();
        try {
            return clientKeyAlg != null ? KeyEncryptionAlgorithm.valueOf(clientKeyAlg) : null;
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchAlgorithmException("Binding parameter \"keyalg\" must be one of " + KeyEncryptionAlgorithm.join(), e);
        }
    }

    private static String getSubject(X509Certificate certificate) throws CertificateException {
        String dn = certificate.getSubjectX500Principal().getName();
        Matcher claimsMatcher = CLAIMS_PATTERN.matcher(dn);
        if (!claimsMatcher.matches()) {
            throw new CertificateException("Invalid subject: " + dn);
        }
        return claimsMatcher.group(1);
    }

    private static byte[] base64Decode(String base64) {
        return Base64.getMimeDecoder().decode(base64.getBytes(StandardCharsets.US_ASCII));
    }

    public static enum KeyEncryptionAlgorithm {
        PBEWithHmacSHA1AndAES_128,
        PBEWithHmacSHA224AndAES_128,
        PBEWithHmacSHA256AndAES_128,
        PBEWithHmacSHA384AndAES_128,
        PBEWithHmacSHA512AndAES_128,
        PBEWithHmacSHA1AndAES_256,
        PBEWithHmacSHA224AndAES_256,
        PBEWithHmacSHA256AndAES_256,
        PBEWithHmacSHA384AndAES_256,
        PBEWithHmacSHA512AndAES_256;


        private static String join() {
            return Arrays.stream(KeyEncryptionAlgorithm.values()).map(Enum::toString).collect(Collectors.joining(","));
        }
    }
}

