/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.kafka.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import java.util.Map;

public class TrustStoreUtilsOauth {
    private TrustStoreUtilsOauth() {
    }

    public static String createTruststoreWithRootCertsFromUrl(String trustStorePass, String rootCertUrl) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        File certFile = File.createTempFile("kafkaRootCACerts", null);
        TrustStoreUtilsOauth.downloadFile(rootCertUrl, certFile);
        return TrustStoreUtilsOauth.createTruststoreWithRootCerts(trustStorePass, certFile.getAbsolutePath());
    }

    private static String createTruststoreWithRootCerts(String trustStorePass, String certFile) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null, trustStorePass.toCharArray());
        Map<String, Certificate> certs = TrustStoreUtilsOauth.loadCerts(certFile);
        keystore.setCertificateEntry("KafkaRootCA", certs.get("current"));
        if (certs.containsKey("next")) {
            keystore.setCertificateEntry("KafkaNextRootCA", certs.get("next"));
        }
        File keystoreFile = File.createTempFile("kafkaTrustStore", null);
        try (FileOutputStream os = new FileOutputStream(keystoreFile);){
            keystore.store(os, trustStorePass.toCharArray());
        }
        return keystoreFile.getAbsolutePath();
    }

    private static Map<String, Certificate> loadCerts(String certFile) throws CertificateException, IOException {
        HashMap<String, Certificate> certs = new HashMap<String, Certificate>();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(certFile));){
            certs.put("current", cf.generateCertificate(is));
            if (((InputStream)is).available() > 0) {
                certs.put("next", cf.generateCertificate(is));
            }
        }
        return certs;
    }

    private static void downloadFile(String url, File output) throws IOException {
        try (ReadableByteChannel in = Channels.newChannel(new URL(url).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(output);
             FileChannel out = fileOutputStream.getChannel();){
            out.transferFrom(in, 0L, Long.MAX_VALUE);
        }
    }
}

