/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.utils.rest.client.JsonRestClient;
import com.sap.cds.services.utils.rest.client.JsonRestClientConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasClient
extends JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(SaasClient.class);
    public static final String SAAS_REGISTRY = "saas-registry";
    private static final String OAUTH_PATH = "/oauth/token";
    private static final String SAAS_MANAGER_BASE = "/saas-manager/v1/";
    private static final String APPLICATION_TENANTS_PATH = "/saas-manager/v1/application/subscriptions";
    private static final String SERVICE_TENANTS_PATH = "/saas-manager/v1/service/subscriptions?includeIndirectSubscriptions=true";
    private static String urlPath;

    public SaasClient(ServiceBinding binding) {
        super(SaasClient.getSaasClientConfiguration(binding));
    }

    private static JsonRestClientConfiguration getSaasClientConfiguration(final ServiceBinding binding) {
        urlPath = "service".equals(binding.getServicePlan()) ? SERVICE_TENANTS_PATH : APPLICATION_TENANTS_PATH;
        return new JsonRestClientConfiguration(){

            public String getName() {
                return "saas-registry-client";
            }

            public String getGrantType() {
                return "client_credentials";
            }

            public String getApiUrl() {
                return binding.getCredentials().get("saas_registry_url").toString();
            }

            public String getTokenEndpoint() {
                return binding.getCredentials().get("url").toString() + SaasClient.OAUTH_PATH;
            }

            public String getClientId() {
                return binding.getCredentials().get("clientid").toString();
            }

            public String getClientSecret() {
                return binding.getCredentials().get("clientsecret").toString();
            }
        };
    }

    public List<Map<String, Object>> getSubscribedTenants() throws IOException {
        logger.debug("Retrieving all tenants metadata from the SaaS registry");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayNode resp = (ArrayNode)this.getRequest(urlPath).get("subscriptions");
        resp.forEach(tenant -> result.add((Map<String, Object>)this.mapper.convertValue(tenant, (TypeReference)new TypeReference<Map<String, Object>>(){})));
        return result;
    }
}

