/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.sap.cds.feature.mt.MtBindingUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.mtx.MtxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtUtils {
    private static final Logger logger = LoggerFactory.getLogger(MtUtils.class);
    private final MtxUtils mtxUtils;
    private final MtBindingUtils mtBindingUtils;

    public MtUtils(CdsRuntime runtime) {
        this.mtxUtils = new MtxUtils(runtime);
        this.mtBindingUtils = new MtBindingUtils(runtime);
    }

    public boolean mtEnabled() {
        return this.mtEnabled(false);
    }

    public boolean mtEnabled(boolean log) {
        boolean requiresExternalDeployer;
        if (this.mtBindingUtils.getMtBindings().isEmpty()) {
            if (log) {
                logger.info("No multitencancy-capable datasource binding found (MT disabled)");
            }
            return false;
        }
        boolean bl = requiresExternalDeployer = !this.mtBindingUtils.getMtBindings().stream().anyMatch(this.mtBindingUtils::isSchemaBasedMtBinding);
        if (requiresExternalDeployer && !this.hasDeployerOrSideCarConfiguration()) {
            if (log) {
                logger.info("No sidecar or deployer URL was specified (MT disabled)");
            }
            return false;
        }
        return true;
    }

    private boolean hasDeployerOrSideCarConfiguration() {
        if (this.mtxUtils.dynamicDeployerEnabled() && this.mtxUtils.mtxEnabled()) {
            throw new IllegalArgumentException("Either Sidecar or Deployer URL can be specified");
        }
        return this.mtxUtils.dynamicDeployerEnabled() || this.mtxUtils.mtxEnabled();
    }
}

