/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.mt.ExtensibilityService;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.mtx.MtxUtils;
import java.util.Set;
import java.util.stream.Collectors;

public class MtxModelProvider
implements CdsModelProvider {
    private final CdsRuntime runtime;
    private final MetaDataAccessor<String> accessor;

    public MtxModelProvider(CdsRuntime runtime) {
        this.runtime = runtime;
        MtxUtils mtxUtils = new MtxUtils(runtime);
        SidecarAccess access = mtxUtils.getSidecarAccess();
        CacheParams cacheParams = mtxUtils.getCacheParams();
        this.accessor = new MetaDataAccessorImpl(access, cacheParams, (edmx, service) -> edmx, null);
        ExtensibilityService extService = (ExtensibilityService)runtime.getServiceCatalog().getService(ExtensibilityService.class, "ExtensibilityService$Default");
        extService.on("MODEL_CHANGED", null, context -> this.accessor.refresh(context.getUserInfo().getTenant()));
    }

    public CdsModel get(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        String tenant = userInfo.getTenant();
        if (tenant == null) {
            return this.runtime.getCdsModel();
        }
        Set features = featureTogglesInfo.getEnabledFeatureToggles().map(ft -> ft.getName()).collect(Collectors.toSet());
        ModelId modelId = ModelId.create((String)tenant).features(features).build();
        int maxAgeSeconds = Integer.MAX_VALUE;
        return this.accessor.getCdsModel(modelId, maxAgeSeconds);
    }
}

