/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.sap.cds.feature.mt.ExecutorUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.mt.MtSubscriptionService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.runtime.HttpParameterInfo;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtSubscriptionServlet
extends HttpServlet {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MtSubscriptionServlet.class);
    public static final String HEADER_STATUS_CALLBACK = "STATUS_CALLBACK";
    private static final String SUBSCRIBE = "subscribe";
    private static final String UNSUBSCRIBE = "unsubscribe";
    private static final String CALLBACK = "/callbacks";
    public static final String SUBSCRIBE_CALLBACK = "/callbacks/subscribe";
    public static final String UNSUBSCRIBE_CALLBACK = "/callbacks/unsubscribe";
    private static final String DEPENDENCIES = "/dependencies";
    private static final String TENANTS = "/tenants";
    private static final String DEPLOY = "/deploy";
    private static final String ASYNC_DEPLOY = "/deploy/async";
    private static final String ASYNC_DEPLOY_STATUS = "/deploy/async/status";
    private final CdsRuntime cdsRuntime;

    public MtSubscriptionServlet(CdsRuntime cdsRuntime) {
        this.cdsRuntime = cdsRuntime;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.processRequest(resp, req, requestContext -> {
            String path = req.getPathInfo();
            logger.debug("Processing get request in mt servlet for path '{}'", (Object)path);
            if (DEPENDENCIES.equals(path)) {
                logger.info("Processing dependency request");
                List<ApplicationDependency> dependencies = this.getService().getDependencies();
                MtSubscriptionServlet.setContentType(resp, ContentType.APPLICATION_JSON);
                resp.setStatus(200);
                resp.getWriter().write(mapper.writeValueAsString(dependencies));
            } else if (path.startsWith(ASYNC_DEPLOY_STATUS)) {
                String jobId = this.getJobId(req);
                if (jobId == null) {
                    resp.setStatus(404);
                    return;
                }
                logger.info("Processing async deploy status request");
                MtSubscriptionServlet.setContentType(resp, ContentType.APPLICATION_JSON);
                resp.setStatus(200);
                resp.getWriter().write(this.getService().asyncDeployStatus(jobId));
            } else {
                resp.setStatus(404);
            }
        });
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) {
        this.processRequest(resp, req, requestContext -> {
            String path = req.getPathInfo();
            if (path.startsWith(TENANTS)) {
                String url;
                SubscriptionPayload payload;
                String tenantId = MtSubscriptionServlet.getSecondPathElement(path);
                if (tenantId == null) {
                    resp.setStatus(404);
                    return;
                }
                logger.info("Creating subscription for tenant '{}'", (Object)MtSubscriptionServlet.removeWhitespaces(tenantId));
                try {
                    payload = (SubscriptionPayload)mapper.readerFor(SubscriptionPayload.class).readValue((InputStream)req.getInputStream());
                }
                catch (MismatchedInputException e) {
                    throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
                }
                String callbackUrl = req.getHeader(HEADER_STATUS_CALLBACK);
                if (callbackUrl != null) {
                    logger.debug("Processing request asynchronously");
                    url = this.getService().asyncSubscribe(payload, tenantId, callbackUrl);
                    resp.setStatus(202);
                } else {
                    logger.debug("Processing request synchronously");
                    url = this.getService().subscribe(payload, tenantId);
                    resp.setStatus(201);
                }
                MtSubscriptionServlet.setContentType(resp, ContentType.TEXT_PLAIN);
                resp.getWriter().write(url);
                return;
            }
            if (!path.startsWith(CALLBACK)) {
                resp.setStatus(404);
                return;
            }
            String callbackType = MtSubscriptionServlet.getSecondPathElement(path);
            if (callbackType == null) {
                resp.setStatus(404);
                return;
            }
            String callbackScope = this.cdsRuntime.getEnvironment().getCdsProperties().getMultiTenancy().getSecurity().getSubscriptionScope();
            if (!requestContext.getUserInfo().isPrivileged() && !requestContext.getUserInfo().hasRole(callbackScope)) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
            }
            if (SUBSCRIBE.equals(callbackType)) {
                SidecarSubscribeCallBackPayload payload = (SidecarSubscribeCallBackPayload)mapper.readerFor(SidecarSubscribeCallBackPayload.class).readValue((InputStream)req.getInputStream());
                logger.info("Subscription for tenant '{}' finished with status '{}'", (Object)MtSubscriptionServlet.removeWhitespaces(payload.tenantId), (Object)MtSubscriptionServlet.removeWhitespaces(payload.status));
                ExecutorUtils.runAsynchronously(this.cdsRuntime, () -> this.getService().finishAsyncSubscribe(payload));
                resp.setStatus(200);
                return;
            }
            if (UNSUBSCRIBE.equals(callbackType)) {
                SidecarUnSubscribeCallBackPayload payload = (SidecarUnSubscribeCallBackPayload)mapper.readerFor(SidecarUnSubscribeCallBackPayload.class).readValue((InputStream)req.getInputStream());
                logger.info("Unsubscription for tenant '{}' finished with status '{}'", (Object)MtSubscriptionServlet.removeWhitespaces(payload.tenantId), (Object)MtSubscriptionServlet.removeWhitespaces(payload.status));
                ExecutorUtils.runAsynchronously(this.cdsRuntime, () -> this.getService().finishAsyncUnsubscribe(payload));
                resp.setStatus(200);
                return;
            }
            resp.setStatus(404);
        });
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) {
        this.processRequest(resp, req, requestContext -> {
            String path = req.getPathInfo();
            if (path.startsWith(TENANTS)) {
                DeletePayload payload;
                String tenantId = MtSubscriptionServlet.getSecondPathElement(path);
                if (tenantId == null) {
                    resp.setStatus(404);
                    return;
                }
                logger.info("Processing unsubscription request for tenant '{}'", (Object)MtSubscriptionServlet.removeWhitespaces(tenantId));
                try {
                    payload = (DeletePayload)mapper.readerFor(DeletePayload.class).readValue((InputStream)req.getInputStream());
                }
                catch (MismatchedInputException e) {
                    throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
                }
                String callbackUrl = req.getHeader(HEADER_STATUS_CALLBACK);
                if (callbackUrl != null) {
                    logger.debug("Processing request asynchronously");
                    this.getService().asyncUnsubscribe(payload, tenantId, callbackUrl);
                    resp.setStatus(202);
                } else {
                    logger.debug("Processing request synchronously");
                    this.getService().unsubscribe(payload, tenantId);
                    resp.setStatus(204);
                }
            } else {
                resp.setStatus(404);
                return;
            }
        });
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.processRequest(resp, req, requestContext -> {
            SidecarUpgradePayload payload;
            String path = req.getPathInfo();
            boolean deploy = DEPLOY.equals(path);
            boolean asyncDeploy = ASYNC_DEPLOY.equals(path);
            if (!deploy && !asyncDeploy) {
                resp.setStatus(404);
                return;
            }
            try {
                payload = (SidecarUpgradePayload)mapper.readerFor(SidecarUpgradePayload.class).readValue((InputStream)req.getInputStream());
            }
            catch (MismatchedInputException e) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
            }
            if (deploy) {
                logger.info("Triggering DB deployment for tenants '{}'", (Object)MtSubscriptionServlet.removeWhitespaces(Arrays.toString(payload.tenants)));
                this.getService().deploy(payload);
                resp.setStatus(200);
            } else {
                logger.info("Triggering asynchronous DB deployment for tenants '{}'", (Object)MtSubscriptionServlet.removeWhitespaces(Arrays.toString(payload.tenants)));
                String deployResult = this.getService().asyncDeploy(payload);
                MtSubscriptionServlet.setContentType(resp, ContentType.APPLICATION_JSON);
                resp.setStatus(202);
                resp.getWriter().write(deployResult);
            }
        });
    }

    private static String getSecondPathElement(String path) {
        String[] paths = path.split("/");
        if (paths.length == 3) {
            return paths[2];
        }
        return null;
    }

    private String getJobId(HttpServletRequest req) {
        String[] paths;
        String id;
        String path = req.getPathInfo();
        if (path.startsWith(ASYNC_DEPLOY_STATUS) && !StringUtils.isEmpty((String)(id = path.replace(ASYNC_DEPLOY_STATUS, ""))) && (paths = id.split("/")).length == 2) {
            return paths[1];
        }
        return null;
    }

    private void processRequest(HttpServletResponse resp, HttpServletRequest servletRequest, HttpRequestProcessor reqProcessor) {
        this.cdsRuntime.requestContext().modifyUser(user -> user.setTenant(null)).parameters(HttpParameterInfo.fromRequest((HttpServletRequest)servletRequest, (CdsRuntime)this.cdsRuntime)).run(req -> {
            block19: {
                try {
                    reqProcessor.process((RequestContext)req);
                }
                catch (ServiceException e) {
                    if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                        logger.error("Unexpected error", (Throwable)e);
                    } else {
                        logger.debug("Service exception thrown", (Throwable)e);
                    }
                    resp.setStatus(e.getErrorStatus().getHttpStatus());
                    try {
                        String message = e.getLocalizedMessage(req.getParameterInfo().getLocale());
                        if (message == null) break block19;
                        try (PrintWriter writer = resp.getWriter();){
                            writer.write(message);
                        }
                    }
                    catch (IOException e1) {
                        logger.error("Failed to write error message to response", (Throwable)e1);
                    }
                }
                catch (Throwable t) {
                    logger.error("Unexpected error", t);
                    resp.setStatus(500);
                }
            }
        });
    }

    private MtSubscriptionService getService() {
        return (MtSubscriptionService)this.cdsRuntime.getServiceCatalog().getService(MtSubscriptionService.class, "MtSubscriptionService$Default");
    }

    private static String removeWhitespaces(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("\\s", "");
    }

    private static void setContentType(HttpServletResponse resp, ContentType contType) {
        resp.setContentType(contType.getMimeType());
        resp.setCharacterEncoding(contType.getCharset().toString());
    }

    @FunctionalInterface
    private static interface HttpRequestProcessor {
        public void process(RequestContext var1) throws ServletException, IOException;
    }
}

