/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbCredentialsBuilder;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersHana;
import com.sap.cloud.mt.subscription.DbIdentifiersSql;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.InstanceLifecycleManagerBuilder;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.xsa.core.instancemanager.client.ImClientException;
import com.sap.xsa.core.instancemanager.client.InstanceManagerClient;
import com.sap.xsa.core.instancemanager.client.ServiceManagerClient;
import com.sap.xsa.core.instancemanager.client.impl.InstanceManagerClientFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MtBindingUtils {
    public static final String SERVICE_MANAGER = "service-manager";
    public static final String MANAGED_HANA = "managed-hana";
    public static final String MT_ENABLED = "mt-enabled";
    private final CdsRuntime runtime;

    public MtBindingUtils(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public List<ServiceBinding> getMtBindings() {
        String instanceManagerForMigration = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getInstanceManagerMigration().getInstanceManagerBindingName();
        return this.runtime.getEnvironment().getServiceBindings().filter(b -> this.isInstanceManagerOrServiceManagerBinding((ServiceBinding)b) || this.isSchemaBasedMtBinding((ServiceBinding)b)).filter(b -> StringUtils.isEmpty((String)instanceManagerForMigration) || !b.getName().equals(instanceManagerForMigration)).collect(Collectors.toList());
    }

    public ServiceBinding getDefaultMtBinding() {
        ServiceBinding binding = null;
        List<ServiceBinding> mtBindings = this.getMtBindings();
        String bindingName = this.runtime.getEnvironment().getCdsProperties().getDataSource().getBinding();
        if (StringUtils.isEmpty((String)bindingName)) {
            if (mtBindings.size() == 1) {
                binding = mtBindings.get(0);
            } else if (mtBindings.size() > 1) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_UNIQUE_DATASOURCE_SERVICE, new Object[0]);
            }
        } else {
            binding = mtBindings.stream().filter(b -> b.getName().equals(bindingName)).findFirst().orElse(null);
        }
        return binding;
    }

    public boolean isInstanceManagerOrServiceManagerBinding(ServiceBinding b) {
        return this.isServiceManagerBinding(b) || this.isInstanceManagerBinding(b);
    }

    private boolean isServiceManagerBinding(ServiceBinding b) {
        return b.matches(SERVICE_MANAGER, SERVICE_MANAGER);
    }

    private boolean isInstanceManagerBinding(ServiceBinding b) {
        return b.matches(MANAGED_HANA, MANAGED_HANA);
    }

    public boolean isSchemaBasedMtBinding(ServiceBinding b) {
        return b.matches(MT_ENABLED, null);
    }

    public InstanceLifecycleManager createInstanceLifecycleManager(ServiceBinding binding) {
        InstanceLifecycleManager newIlm;
        InstanceLifecycleManagerBuilder builder = InstanceLifecycleManagerBuilder.create();
        if (this.isInstanceManagerOrServiceManagerBinding(binding)) {
            builder.instanceManagerClient(this.getInstanceManagerClientWithMigrationSupport(binding));
            builder.dbIdentifiers(this.getHanaDatabaseIds());
            builder.timeout(this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getServiceManager().getTimeout());
            try {
                newIlm = builder.build();
            }
            catch (InternalError internalError) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName(), internalError});
            }
        }
        try {
            DbCredentials dbCredentials = DbCredentialsBuilder.create().credentials(binding.getCredentials()).build();
            builder.dbIdentifiers((DbIdentifiers)new DbIdentifiersSql(Collections.singletonList(dbCredentials)));
            newIlm = builder.build();
        }
        catch (InternalError internalError) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MT_LIB_SETUP_FAILED, new Object[]{internalError.getMessage(), internalError});
        }
        return newIlm;
    }

    public InstanceManagerClient getInstanceManagerClient(ServiceBinding binding) {
        try {
            Map credentials = binding.getCredentials();
            if (this.isServiceManagerBinding(binding)) {
                if (!StringUtils.isEmpty((String)((String)credentials.get("clientsecret")))) {
                    return InstanceManagerClientFactory.getInstance((String)((String)credentials.get("xsappname")), (String)((String)credentials.get("sm_url")), (String)((String)credentials.get("url")), (String)((String)credentials.get("clientid")), (String)((String)credentials.get("clientsecret")));
                }
                if (!StringUtils.isEmpty((String)((String)credentials.get("certificate")))) {
                    return InstanceManagerClientFactory.getInstance((String)((String)credentials.get("xsappname")), (String)((String)credentials.get("sm_url")), (String)((String)credentials.get("certurl")), (String)((String)credentials.get("clientid")), (String)((String)credentials.get("key")), (String)((String)credentials.get("certificate")));
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName()});
            }
            return InstanceManagerClientFactory.getInstance((String)((String)credentials.get("get_all_managed_instances_url")), (String)((String)credentials.get("user")), (String)((String)credentials.get("password")));
        }
        catch (ImClientException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName(), e});
        }
    }

    @VisibleForTesting
    InstanceManagerClient getInstanceManagerClientWithMigrationSupport(ServiceBinding binding) {
        ServiceBinding defaultBinding;
        InstanceManagerClient mainClient = this.getInstanceManagerClient(binding);
        String migrationIMName = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getInstanceManagerMigration().getInstanceManagerBindingName();
        if (!StringUtils.isEmpty((String)migrationIMName) && mainClient instanceof ServiceManagerClient && (defaultBinding = this.getDefaultMtBinding()) != null && defaultBinding.getName().equals(binding.getName())) {
            ServiceBinding instanceManagerMigrationBinding = this.runtime.getEnvironment().getServiceBindings().filter(this::isInstanceManagerBinding).filter(b -> b.getName().equals(migrationIMName)).findFirst().orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_SERVICE_NAME, new Object[]{migrationIMName}));
            InstanceManagerClient migrationClient = this.getInstanceManagerClient(instanceManagerMigrationBinding);
            mainClient = InstanceManagerClientFactory.getInstance((InstanceManagerClient)migrationClient, (ServiceManagerClient)((ServiceManagerClient)mainClient));
        }
        return mainClient;
    }

    public DbIdentifiers getHanaDatabaseIds() {
        CdsProperties.MultiTenancy config = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        return new DbIdentifiersHana(new HashSet(config.getDataSource().getHanaDatabaseIds()));
    }
}

