/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.sap.cds.feature.mt.MtBindingUtils;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtUtils {
    private static final Logger logger = LoggerFactory.getLogger(MtUtils.class);
    private final CdsRuntime runtime;
    private final DynamicModelUtils dynamicModelUtils;
    private final MtBindingUtils mtBindingUtils;
    private final CdsProperties.MultiTenancy multiTenancy;
    private final CdsProperties.MultiTenancy.ProvisioningService provisioning;
    private final CdsProperties.MultiTenancy.Sidecar sidecar;

    public MtUtils(CdsRuntime runtime) {
        this.runtime = runtime;
        this.dynamicModelUtils = new DynamicModelUtils(runtime);
        this.mtBindingUtils = new MtBindingUtils(runtime);
        this.multiTenancy = runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        this.provisioning = this.multiTenancy.getProvisioning();
        this.sidecar = this.multiTenancy.getSidecar();
    }

    public boolean mtEnabled() {
        return this.mtEnabled(false);
    }

    public boolean mtEnabled(boolean log) {
        boolean requiresExternalDeployer;
        if (this.mtBindingUtils.getMtBindings().isEmpty()) {
            if (log) {
                logger.info("No multitenancy-capable datasource binding found (MT disabled)");
            }
            return false;
        }
        boolean bl = requiresExternalDeployer = !this.mtBindingUtils.getMtBindings().stream().anyMatch(this.mtBindingUtils::isSchemaBasedMtBinding);
        if (requiresExternalDeployer && !this.hasDeployer()) {
            if (log) {
                logger.info("No sidecar or deployer URL was specified (MT disabled)");
            }
            return false;
        }
        return true;
    }

    private boolean hasDeployer() {
        boolean sidecarOrProvisioningService;
        boolean dynamicDeployer = !StringUtils.isEmpty((String)this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getDeployer().getUrl());
        boolean bl = sidecarOrProvisioningService = this.isClassicSidecarEnabled() || this.isProvisioningServiceEnabled();
        if (dynamicDeployer && sidecarOrProvisioningService) {
            throw new IllegalArgumentException(" Either Sidecar or Deployer URL can be specified");
        }
        return dynamicDeployer || sidecarOrProvisioningService;
    }

    public boolean isClassicSidecarEnabled() {
        return this.dynamicModelUtils.isClassicSidecarEnabled();
    }

    public boolean isProvisioningServiceEnabled() {
        return this.multiTenancy.getMtxs().isEnabled() != false && !StringUtils.isEmpty((String)this.getProvisioningServiceUrl());
    }

    public String getProvisioningServiceUrl() {
        return !StringUtils.isEmpty((String)this.provisioning.getUrl()) ? this.provisioning.getUrl() : this.sidecar.getUrl();
    }
}

