/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.sap.cds.feature.mt.MtBindingUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.datasource.DataSourceFactory;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.datasource.DataSourceUtils;
import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceLookup;
import com.sap.cloud.mt.runtime.DataSourceLookupBuilder;
import com.sap.cloud.mt.runtime.EnvironmentAccess;
import com.sap.cloud.mt.runtime.IdentityZoneDeterminer;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import com.sap.cloud.mt.runtime.TenantProvider;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public class RoutingDataSourceFactory
implements DataSourceFactory,
CdsRuntimeAware {
    private static final String DATA_SOURCE_SECTION_MT = "cds.multitenancy.datasource.";
    private CdsRuntime runtime;
    private MtBindingUtils mtBindingUtils;

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
        this.mtBindingUtils = new MtBindingUtils(runtime);
    }

    public Map<String, DataSource> create() {
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>();
        for (ServiceBinding binding : this.mtBindingUtils.getMtBindings()) {
            DataSource dataSource = this.createRoutingDataSource(binding);
            dataSources.put(binding.getName(), dataSource);
        }
        return dataSources;
    }

    private DataSource createRoutingDataSource(ServiceBinding binding) {
        CdsProperties.MultiTenancy multiTenancy = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        try {
            InstanceLifecycleManager lifeCycleManager = this.mtBindingUtils.createInstanceLifecycleManager(binding);
            Map<String, DataPoolSettings.ConnectionPoolType> parameterConfig = this.createParameterConfig(binding.getName());
            DataSourceLookup lookup = DataSourceLookupBuilder.create().instanceLifecycleManager(lifeCycleManager).environmentAccess(new EnvironmentAccess(){

                public <T> T getProperty(String key, Class<T> clazz) {
                    return (T)RoutingDataSourceFactory.this.runtime.getEnvironment().getProperty(key, clazz, null);
                }

                public Map<Object, Object> getPropertiesForPrefix(String prefix) {
                    return this.getProperty(prefix, HashMap.class);
                }
            }).prefixToPoolType(parameterConfig).poolProvider(multiTenancy.getDataSource().getPool()).oneDataSourcePerDb(multiTenancy.getDataSource().getCombinePools().isEnabled().booleanValue()).build();
            TenantProvider provider = new TenantProvider(new IdentityZoneDeterminer(){

                public String getIdentityZone() throws InternalError {
                    String tenant = RequestContext.getCurrent((CdsRuntime)RoutingDataSourceFactory.this.runtime).getUserInfo().getTenant();
                    if (tenant == null) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_CONTEXT_MISSING, new Object[0]);
                    }
                    return tenant;
                }
            });
            return new TenantAwareDataSource(provider, lookup);
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName(), e});
        }
    }

    private Map<String, DataPoolSettings.ConnectionPoolType> createParameterConfig(String name) {
        LinkedHashMap<String, DataPoolSettings.ConnectionPoolType> config = new LinkedHashMap<String, DataPoolSettings.ConnectionPoolType>();
        this.addConfigParameter(config, DataPoolSettings.ConnectionPoolType.HIKARI, DataSourceUtils.PoolType.HIKARI, name);
        this.addConfigParameter(config, DataPoolSettings.ConnectionPoolType.TOMCAT, DataSourceUtils.PoolType.TOMCAT, name);
        this.addConfigParameter(config, DataPoolSettings.ConnectionPoolType.ATOMIKOS, DataSourceUtils.PoolType.ATOMIKOS, name);
        return config;
    }

    private void addConfigParameter(Map<String, DataPoolSettings.ConnectionPoolType> config, DataPoolSettings.ConnectionPoolType type, DataSourceUtils.PoolType poolType, String name) {
        config.put(DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)poolType), type);
        config.put(DATA_SOURCE_SECTION_MT + poolType, type);
    }
}

