/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Objects;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.utils.rest.client.JsonRestClient;
import com.sap.cds.services.utils.rest.client.JsonRestClientConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasClient
extends JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(SaasClient.class);
    private static final String TENANT_STATE = "state";
    public static final String SAAS_REGISTRY = "saas-registry";
    private static final String SAAS_MANAGER_BASE = "/saas-manager/v1/";
    private static final String APPLICATION_TENANTS_PATH = "/saas-manager/v1/application/subscriptions";
    private static final String SERVICE_TENANTS_PATH = "/saas-manager/v1/service/subscriptions?includeIndirectSubscriptions=true";
    private static String urlPath;

    public SaasClient(ServiceBinding binding) {
        super(SaasClient.getSaasClientConfiguration(binding), binding.getCredentials());
    }

    private static JsonRestClientConfiguration getSaasClientConfiguration(final ServiceBinding binding) {
        urlPath = "service".equals(binding.getServicePlan()) ? SERVICE_TENANTS_PATH : APPLICATION_TENANTS_PATH;
        return new JsonRestClientConfiguration(){

            public String getName() {
                return "saas-registry-client";
            }

            public String getApiUrl() {
                return binding.getCredentials().get("saas_registry_url").toString();
            }
        };
    }

    public List<Map<String, Object>> getSubscribedTenants() throws IOException {
        logger.debug("Retrieving all tenants metadata from the SaaS registry");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayNode resp = (ArrayNode)this.getRequest(urlPath).get("subscriptions");
        resp.forEach(tenant -> {
            String state;
            String string = state = tenant.get(TENANT_STATE) != null ? tenant.get(TENANT_STATE).asText() : null;
            if (Objects.equal((Object)state, (Object)"SUBSCRIBED") || Objects.equal((Object)state, (Object)"UPDATE_FAILED")) {
                result.add((Map<String, Object>)this.mapper.convertValue(tenant, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
        });
        return result;
    }
}

