/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.feature.mt.ExecutorUtils;
import com.sap.cds.feature.mt.MtUtils;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.ClientCredentialJwtAccess;
import com.sap.cds.mtx.impl.ClientCredentialJwtReader;
import com.sap.cds.mtx.impl.XsuaaParams;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.authentication.JwtTokenAuthenticationInfo;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.MtAsyncDeployEventContext;
import com.sap.cds.services.mt.MtAsyncDeployStatusEventContext;
import com.sap.cds.services.mt.MtAsyncSubscribeEventContext;
import com.sap.cds.services.mt.MtAsyncSubscribeFinishedEventContext;
import com.sap.cds.services.mt.MtAsyncUnsubscribeEventContext;
import com.sap.cds.services.mt.MtAsyncUnsubscribeFinishedEventContext;
import com.sap.cds.services.mt.MtDeployEventContext;
import com.sap.cds.services.mt.MtGetDependenciesEventContext;
import com.sap.cds.services.mt.MtSubscribeEventContext;
import com.sap.cds.services.mt.MtUnsubscribeEventContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import com.sap.cloud.mt.subscription.DynamicHdiDeploymentParameters;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.subscription.ProvisioningServiceSpecification;
import com.sap.cloud.mt.subscription.SaasRegistry;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.Subscriber;
import com.sap.cloud.mt.subscription.SubscriberBuilder;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.NotSupported;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exits.Exits;
import com.sap.cloud.mt.subscription.exits.SubscribeExit;
import com.sap.cloud.mt.subscription.exits.UnSubscribeExit;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"MtSubscriptionService$Default"})
public class MtSubscriptionDefaultOnHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(MtSubscriptionDefaultOnHandler.class);
    private static final String SUCCEEDED = "SUCCEEDED";
    private static final String FAILED = "FAILED";
    private static final Duration SAAS_REGISTRY_RACECOND_DURATION = Duration.ofSeconds(10L);
    private final CdsRuntime runtime;
    private final DynamicModelUtils dynamicModelUtils;
    private final MtUtils mtUtils;
    private final boolean mtxs;
    private final Subscriber subscriber;
    private final ThreadLocal<InstanceCreationOptions> options;
    private final String callbackScope;
    private final String deployScope;

    public MtSubscriptionDefaultOnHandler(InstanceLifecycleManager instanceLifecycleManager, Optional<ServiceBinding> saasRegistryBinding, CdsRuntime runtime) {
        this.runtime = runtime;
        this.dynamicModelUtils = new DynamicModelUtils(runtime);
        this.mtUtils = new MtUtils(runtime);
        CdsProperties.MultiTenancy config = runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        this.mtxs = config.getMtxs().isEnabled();
        this.callbackScope = config.getSecurity().getSubscriptionScope();
        this.deployScope = config.getSecurity().getDeploymentScope();
        this.options = new ThreadLocal();
        Exits exits = new Exits(new UnSubscribeExit(){

            public Boolean onBeforeUnsubscribe(String tenantId, DeletePayload deletePayload) {
                return true;
            }

            public Boolean onBeforeAsyncUnsubscribe(String tenantId, DeletePayload deletePayload) {
                return true;
            }
        }, new SubscribeExit(){

            public InstanceCreationOptions onBeforeSubscribe(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError {
                return (InstanceCreationOptions)MtSubscriptionDefaultOnHandler.this.options.get();
            }

            public InstanceCreationOptions onBeforeAsyncSubscribe(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError {
                return (InstanceCreationOptions)MtSubscriptionDefaultOnHandler.this.options.get();
            }
        }, null, null, null);
        try {
            SaasRegistry saasRegistry = this.createSaasRegistry(saasRegistryBinding);
            DynamicHdiDeploymentParameters hdiDeploymentParameters = new DynamicHdiDeploymentParameters(config.getDeployer().getUrl(), config.getDeployer().getUser(), config.getDeployer().getPassword(), config.getDeployer().getAsyncTimeout().getSeconds(), 5L);
            ProvisioningServiceSpecification provisioningServiceSpecification = null;
            if (this.mtxs) {
                provisioningServiceSpecification = this.getProvisioningServiceSpecification(config);
            }
            this.subscriber = SubscriberBuilder.create().instanceLifecycleManager(instanceLifecycleManager).hdiDeploymentParas(hdiDeploymentParameters).baseUiUrl(this.getAppUiUrl()).urlSeparator(config.getAppUi().getTenantSeparator()).exits(exits).securityChecker(this.getSecurityChecker()).saasRegistry(saasRegistry).sideCarUrl(config.getSidecar().getVersion() < 3 ? config.getSidecar().getUrl() : null).liquibaseFileName(config.getLiquibase().getChangeLog()).liquibaseContexts(config.getLiquibase().getContexts()).resilienceConfig(this.dynamicModelUtils.getResilienceConfig()).provisioningServiceSpecification(provisioningServiceSpecification).build();
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SUBSCRIBER_FAILED, new Object[]{e});
        }
    }

    private SaasRegistry createSaasRegistry(Optional<ServiceBinding> saasRegistryBinding) {
        if (saasRegistryBinding.isPresent()) {
            log.info("Enabled asynchronous subscription for saas-registry service '{}'", (Object)saasRegistryBinding.get().getName());
            Map credentials = saasRegistryBinding.get().getCredentials();
            String saasRegistryUrl = (String)credentials.get("saas_registry_url");
            return new SaasRegistry(this.createAuthenticator(saasRegistryBinding.get().getCredentials()), saasRegistryUrl);
        }
        log.info("Found no 'saas-registry' binding (Asynchronous subscription disabled)");
        return null;
    }

    private Authenticator createAuthenticator(Map<String, Object> xsuaaCredentials) {
        return new ClientCredentialJwtAccess(new ClientCredentialJwtReader(new XsuaaParams(xsuaaCredentials)));
    }

    private SecurityChecker getSecurityChecker() {
        return new SecurityChecker(){

            public void checkSubscriptionAuthority() throws AuthorityError {
            }

            public void checkInitDbAuthority() throws AuthorityError {
            }
        };
    }

    @Before(event={"SUBSCRIBE", "UNSUBSCRIBE", "GET_DEPENDENCIES", "ASYNC_SUBSCRIBE", "ASYNC_UNSUBSCRIBE", "ASYNC_SUBSCRIBE_FINISHED", "ASYNC_UNSUBSCRIBE_FINISHED"})
    @HandlerOrder(value=-10900)
    protected void checkAuthorization(EventContext context) {
        if (!context.getUserInfo().isPrivileged() && !context.getUserInfo().hasRole(this.callbackScope)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
        }
    }

    @Before(event={"DEPLOY", "ASYNC_DEPLOY", "ASYNC_DEPLOY_STATUS"})
    @HandlerOrder(value=-10900)
    protected void checkAuthorizationDeployment(EventContext context) {
        if (!context.getUserInfo().isPrivileged() && !context.getUserInfo().hasRole(this.deployScope)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onGetDependencies(MtGetDependenciesEventContext context) {
        context.setResult(new ArrayList<ApplicationDependency>());
    }

    @On
    @HandlerOrder(value=11000)
    protected void onSubscribe(MtSubscribeEventContext context) {
        try {
            this.options.set(context.getInstanceCreationOptions());
            context.setResult(this.subscriber.subscribe(context.getTenantId(), context.getSubscriptionPayload(), this.getBearerAuthorizationHeader()));
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SUBSCRIPTION_FAILED, new Object[]{context.getTenantId(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onUnsubscribe(MtUnsubscribeEventContext context) {
        try {
            if (context.getDelete() != null && context.getDelete().booleanValue()) {
                log.info("Deleting subscription of tenant '{}'", (Object)context.getTenantId());
                this.subscriber.unsubscribe(context.getTenantId(), context.getDeletePayload(), this.getBearerAuthorizationHeader());
            } else {
                log.info("Skipping subscription deletion of tenant '{}'", (Object)context.getTenantId());
            }
            context.setCompleted();
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUBSCRIPTION_FAILED, new Object[]{context.getTenantId(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onDeploy(MtDeployEventContext context) {
        try {
            this.subscriber.setupDbTables(Arrays.asList(context.getUpgradePayload().tenants), null);
            context.setCompleted();
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DEPLOYMENT_FAILED, new Object[]{String.join((CharSequence)", ", context.getUpgradePayload().tenants), e});
        }
        catch (NotSupported e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[]{e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onDeployAsync(MtAsyncDeployEventContext context) {
        try {
            String authorizationHeader = context.getAuthorizationHeader() != null ? context.getAuthorizationHeader() : this.getBearerAuthorizationHeader();
            context.setResult(this.subscriber.setupDbTablesAsync(Arrays.asList(context.getUpgradePayload().tenants), authorizationHeader));
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DEPLOYMENT_FAILED, new Object[]{String.join((CharSequence)", ", context.getUpgradePayload().tenants), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onDeployAsyncStatus(MtAsyncDeployStatusEventContext context) {
        try {
            String authorizationHeader = context.getAuthorizationHeader() != null ? context.getAuthorizationHeader() : this.getBearerAuthorizationHeader();
            context.setResult(this.subscriber.updateStatus(context.getJobId(), authorizationHeader));
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.JOB_STATUS_UPDATE_FAILED, new Object[]{context.getJobId(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
        catch (NotSupported e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[]{e});
        }
        catch (NotFound e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.JOB_NOT_FOUND, new Object[]{context.getJobId(), e});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onSubscribeAsync(MtAsyncSubscribeEventContext context) {
        try {
            this.options.set(context.getInstanceCreationOptions());
            if (this.mtxs) {
                context.setResult("");
                ExecutorUtils.runAsynchronously(this.runtime, () -> {
                    SidecarSubscribeCallBackPayload payload = new SidecarSubscribeCallBackPayload();
                    payload.tenantId = context.getTenantId();
                    payload.saasRequestPayload = new SidecarSubscriptionPayload(context.getSubscriptionPayload());
                    payload.saasCallbackUrl = context.getSaasRegistryCallbackUrl();
                    try {
                        payload.saasRequestPayload._applicationUrlFromJava_ = this.subscriber.subscribe(context.getTenantId(), context.getSubscriptionPayload(), this.getBearerAuthorizationHeader());
                        payload.status = SUCCEEDED;
                        payload.message = "Subscription succeeded";
                    }
                    catch (Exception e) {
                        log.warn("Asynchronous subscription of tenant '{}' failed", (Object)context.getTenantId(), (Object)e);
                        MtSubscriptionDefaultOnHandler.waitSomeTime(SAAS_REGISTRY_RACECOND_DURATION);
                        payload.status = FAILED;
                        payload.message = "Subscription failed";
                    }
                    context.getService().finishAsyncSubscribe(payload);
                });
            } else {
                context.setResult(this.subscriber.subscribe(context.getTenantId(), context.getSubscriptionPayload(), this.getBearerAuthorizationHeader(), context.getSaasRegistryCallbackUrl(), this.getOwnSubscriptionCallbackEndpoint()));
            }
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SUBSCRIPTION_FAILED, new Object[]{context.getTenantId(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onSubscribeAsyncFinished(MtAsyncSubscribeFinishedEventContext context) {
        try {
            if (this.mtxs) {
                SidecarSubscribeCallBackPayload callbackPayload = context.getCallbackPayload();
                this.subscriber.callSaasRegistry(callbackPayload.status.equals(SUCCEEDED), callbackPayload.message, callbackPayload.saasRequestPayload._applicationUrlFromJava_, callbackPayload.saasCallbackUrl);
            } else {
                this.subscriber.subscribeCallback(this.getBearerAuthorizationHeader(), context.getCallbackPayload());
            }
            context.setCompleted();
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SUBSCRIBE_CALLBACK_FAILED, new Object[]{context.getCallbackPayload().tenantId, e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onUnsubscribeAsync(MtAsyncUnsubscribeEventContext context) {
        try {
            if (context.getDelete() != null && context.getDelete().booleanValue()) {
                log.info("Deleting subscription of tenant '{}'", (Object)context.getTenantId());
                if (this.mtxs) {
                    ExecutorUtils.runAsynchronously(this.runtime, () -> {
                        SidecarUnSubscribeCallBackPayload payload = new SidecarUnSubscribeCallBackPayload();
                        payload.tenantId = context.getTenantId();
                        payload.saasRequestPayload = new SidecarUnSubscriptionPayload(context.getDeletePayload());
                        payload.saasCallbackUrl = context.getSaasRegistryCallbackUrl();
                        try {
                            this.subscriber.unsubscribe(context.getTenantId(), context.getDeletePayload(), this.getBearerAuthorizationHeader());
                            payload.status = SUCCEEDED;
                            payload.message = "Removing subscription succeeded";
                        }
                        catch (Exception e) {
                            log.warn("Asynchronous unsubscription of tenant '{}' failed", (Object)context.getTenantId(), (Object)e);
                            MtSubscriptionDefaultOnHandler.waitSomeTime(SAAS_REGISTRY_RACECOND_DURATION);
                            payload.status = FAILED;
                            payload.message = "Removing subscription failed";
                        }
                        context.getService().finishAsyncUnsubscribe(payload);
                    });
                } else {
                    this.subscriber.unsubscribe(context.getTenantId(), context.getDeletePayload(), this.getBearerAuthorizationHeader(), context.getSaasRegistryCallbackUrl(), this.getOwnUnSubscriptionCallbackEndpoint());
                }
            } else {
                log.info("Skipping subscription deletion of tenant '{}'", (Object)context.getTenantId());
                SidecarUnSubscribeCallBackPayload payload = new SidecarUnSubscribeCallBackPayload();
                payload.tenantId = context.getTenantId();
                payload.status = SUCCEEDED;
                payload.saasCallbackUrl = context.getSaasRegistryCallbackUrl();
                payload.saasRequestPayload = new SidecarUnSubscriptionPayload(context.getDeletePayload());
                ExecutorUtils.runAsynchronously(this.runtime, () -> {
                    MtSubscriptionDefaultOnHandler.waitSomeTime(SAAS_REGISTRY_RACECOND_DURATION);
                    context.getService().finishAsyncUnsubscribe(payload);
                });
            }
            context.setCompleted();
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUBSCRIPTION_FAILED, new Object[]{context.getTenantId(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected void onUnsubscribeAsyncFinished(MtAsyncUnsubscribeFinishedEventContext context) {
        try {
            if (this.mtxs) {
                SidecarUnSubscribeCallBackPayload callbackPayload = context.getCallbackPayload();
                this.subscriber.callSaasRegistry(callbackPayload.status.equals(SUCCEEDED), callbackPayload.message, "", callbackPayload.saasCallbackUrl);
            } else {
                this.subscriber.unsubscribeCallback(context.getCallbackPayload(), this.getBearerAuthorizationHeader());
            }
            context.setCompleted();
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUBSCRIBE_CALLBACK_FAILED, new Object[]{context.getCallbackPayload().tenantId, e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    private String getBearerAuthorizationHeader() {
        AuthenticationInfo authenticationInfo = this.runtime.getProvidedAuthenticationInfo();
        if (authenticationInfo != null && authenticationInfo.is(JwtTokenAuthenticationInfo.class)) {
            JwtTokenAuthenticationInfo accessToken = (JwtTokenAuthenticationInfo)authenticationInfo.as(JwtTokenAuthenticationInfo.class);
            String jwt = accessToken.getToken();
            if (jwt == null || jwt.startsWith("Bearer ")) {
                return jwt;
            }
            return "Bearer " + jwt;
        }
        return null;
    }

    private String getOwnSubscriptionCallbackEndpoint() {
        return this.getOwnCallbackEndpoint("/callbacks/subscribe");
    }

    private String getOwnUnSubscriptionCallbackEndpoint() {
        return this.getOwnCallbackEndpoint("/callbacks/unsubscribe");
    }

    private String getOwnCallbackEndpoint(String callbackType) {
        CdsProperties.MultiTenancy config = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        String callbackUrl = config.getCallbackUrl();
        String endpoint = config.getEndpoint().getPath();
        return callbackUrl + endpoint + callbackType;
    }

    private String getAppUiUrl() {
        String url = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getAppUi().getUrl();
        if (url != null) {
            return url.replaceFirst("^http[s]?://", "");
        }
        return url;
    }

    private static PollingParameters getProvisioningPollingParameter(CdsProperties.MultiTenancy config) {
        return PollingParameters.Builder.create().interval(config.getProvisioning().getPollingInterval()).timeout(config.getProvisioning().getPollingTimeout()).build();
    }

    private ProvisioningServiceSpecification getProvisioningServiceSpecification(CdsProperties.MultiTenancy mtConfig) {
        String url = this.mtUtils.getProvisioningServiceUrl();
        if (StringUtils.isEmpty((String)url)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_PROVISIONINGSERVICE_URL, new Object[0]);
        }
        ClientCredentialJwtReader jwtReader = this.dynamicModelUtils.createClientCredentialJwtReader();
        Authenticator jwtAccess = jwtReader != null ? new ClientCredentialJwtAccess(jwtReader) : Authenticator.NONE;
        ProvisioningServiceSpecification provisioningServiceSpecification = ProvisioningServiceSpecification.Builder.create().authenticator(jwtAccess).url(url).resilienceConfig(this.dynamicModelUtils.getResilienceConfig()).polling(MtSubscriptionDefaultOnHandler.getProvisioningPollingParameter(mtConfig)).build();
        return provisioningServiceSpecification;
    }

    private static void waitSomeTime(Duration waitTime) {
        try {
            Thread.sleep(waitTime.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

