/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.ReadTenantsEventContext;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.util.stream.Collectors;

@ServiceName(value={"TenantProviderService$Default"}, type={TenantProviderService.class})
public class MtTenantProviderHandler
implements EventHandler {
    private final InstanceLifecycleManager ilm;

    public MtTenantProviderHandler(InstanceLifecycleManager ilm) {
        this.ilm = ilm;
    }

    @On
    @HandlerOrder(value=10900)
    public void readTenants(ReadTenantsEventContext context) {
        try {
            context.setResult(this.ilm.getAllTenants(true).stream().map(this::toTenantInfo).collect(Collectors.toList()));
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_READ_FAILED, new Object[]{e});
        }
    }

    private TenantInfo toTenantInfo(String tenant) {
        TenantInfo info = TenantInfo.create();
        info.setTenant(tenant);
        return info;
    }
}

